/*
 * Decompiled with CFR 0.152.
 */
package org.obo.datamodel.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.bbop.util.TinySet;
import org.obo.datamodel.DanglingObject;
import org.obo.datamodel.Datatype;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkDatabase;
import org.obo.datamodel.LinkLinkedObject;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.Namespace;
import org.obo.datamodel.OBOClass;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.OBOSession;
import org.obo.datamodel.ObjectFactory;
import org.obo.datamodel.PropertyValue;
import org.obo.datamodel.SynonymType;
import org.obo.datamodel.TermSubset;
import org.obo.datamodel.UnknownStanza;
import org.obo.datamodel.impl.AnnotatedObjectImpl;
import org.obo.datamodel.impl.DefaultLinkDatabase;
import org.obo.datamodel.impl.DefaultObjectFactory;
import org.obo.datamodel.impl.DefaultOperationModel;
import org.obo.history.DefaultHistoryList;
import org.obo.history.HistoryItem;
import org.obo.history.OperationModel;
import org.obo.history.SessionHistoryList;
import org.obo.identifier.IDProfile;
import org.obo.query.QueryResolver;
import org.obo.util.TermUtil;

public class OBOSessionImpl
implements OBOSession {
    protected static final Logger logger = Logger.getLogger(OBOSessionImpl.class);
    private static final long serialVersionUID = 6487885507983696952L;
    protected static transient OBOSessionImpl serializingSession;
    protected SessionHistoryList currentHistory;
    protected List<SessionHistoryList> archivedHistories;
    protected ObjectFactory objectFactory;
    protected LinkDatabase linkDatabase = new DefaultLinkDatabase(this);
    protected Pattern p = Pattern.compile("(.+)([-|~])(.+)[-|~]>(.+)");
    protected Collection<TermSubset> categories;
    protected Collection<SynonymType> synonymCategories;
    protected Collection<Namespace> namespaces;
    protected Map<String, IdentifiedObject> idHash;
    protected Collection<PropertyValue> propertyValues;
    protected Collection<UnknownStanza> unknownStanzas;
    protected Namespace defaultNamespace;
    protected IDProfile profile;
    protected Map<String, String> idspaceToUri = new HashMap<String, String>();
    protected String loadRemark;
    protected Collection<String> currentFiles;
    protected OperationModel operationModel;
    protected String currentUser;

    @Override
    public void setIDProfile(IDProfile profile) {
        this.profile = profile;
    }

    @Override
    public IDProfile getIDProfile() {
        return this.profile;
    }

    @Override
    public List<SessionHistoryList> getArchivedHistories() {
        return this.archivedHistories;
    }

    @Override
    public String getLoadRemark() {
        return this.loadRemark;
    }

    @Override
    public void setLoadRemark(String loadRemark) {
        this.loadRemark = loadRemark;
    }

    @Override
    public Collection<String> getCurrentFilenames() {
        return this.currentFiles;
    }

    @Override
    public void setCurrentFilenames(String currentFile) {
        ArrayList<String> files = new ArrayList<String>();
        files.add(currentFile);
        this.setCurrentFilenames(files);
    }

    @Override
    public void setCurrentFilenames(Collection<String> currentFiles) {
        this.currentFiles = currentFiles;
    }

    @Override
    public void setDefaultNamespace(Namespace ns) {
        this.defaultNamespace = ns;
    }

    @Override
    public Namespace getDefaultNamespace() {
        return this.defaultNamespace;
    }

    @Override
    public void addNamespace(Namespace ns) {
        if (ns == null) {
            new Exception("Null namespace added").printStackTrace();
        }
        this.namespaces.add(ns);
    }

    @Override
    public Namespace getNamespace(String id) {
        if (id == null) {
            return null;
        }
        for (Namespace ns : this.namespaces) {
            if (!ns.getID().equals(id)) continue;
            return ns;
        }
        return null;
    }

    @Override
    public void removeNamespace(Namespace ns) {
        this.namespaces.remove(ns);
    }

    @Override
    public Collection<Namespace> getNamespaces() {
        return this.namespaces;
    }

    @Override
    public LinkDatabase getLinkDatabase() {
        return this.linkDatabase;
    }

    public OBOSessionImpl() {
        this(new DefaultObjectFactory());
    }

    public OBOSessionImpl(ObjectFactory factory) {
        int i;
        this.currentHistory = new DefaultHistoryList();
        this.operationModel = new DefaultOperationModel();
        this.operationModel.setSession(this);
        this.categories = new TinySet();
        this.synonymCategories = new TinySet();
        this.namespaces = new TinySet();
        this.propertyValues = new TinySet();
        this.unknownStanzas = new TinySet();
        this.idHash = new LinkedHashMap<String, IdentifiedObject>();
        this.archivedHistories = new LinkedList<SessionHistoryList>();
        for (i = 0; i < OBOClass.BUILTIN_CLASSES.length; ++i) {
            this.addObject((OBOClass)OBOClass.BUILTIN_CLASSES[i].clone());
        }
        for (i = 0; i < OBOProperty.BUILTIN_TYPES.length; ++i) {
            this.addObject((OBOProperty)OBOProperty.BUILTIN_TYPES[i].clone());
        }
        for (i = 0; i < Datatype.DATATYPES.length; ++i) {
            this.addObject(Datatype.DATATYPES[i]);
        }
        this.objectFactory = factory;
    }

    @Deprecated
    public void changeID(AnnotatedObjectImpl object, String newID) {
        LinkedObject lobj;
        this.removeObject(object);
        LinkedList<Link> parents = null;
        LinkedList<Link> children = null;
        if (object instanceof LinkedObject) {
            lobj = (LinkedObject)((Object)object);
            parents = new LinkedList<Link>();
            children = new LinkedList<Link>();
            parents.addAll(lobj.getParents());
            children.addAll(lobj.getChildren());
            for (Link link : parents) {
                lobj.removeParent(link);
            }
            for (Link link : children) {
                lobj.removeChild(link);
            }
        }
        object.setID(newID);
        this.addObject(object);
        if (object instanceof LinkedObject) {
            lobj = (LinkedObject)((Object)object);
            for (Link link : parents) {
                lobj.addParent(link);
            }
            for (Link link : children) {
                lobj.addChild(link);
            }
        }
    }

    @Override
    public SessionHistoryList getCurrentHistory() {
        return this.currentHistory;
    }

    @Override
    public void addPropertyValue(PropertyValue pv) {
        this.propertyValues.add(pv);
    }

    @Override
    public Collection<PropertyValue> getPropertyValues() {
        return this.propertyValues;
    }

    @Override
    public void addUnknownStanza(UnknownStanza us) {
        this.unknownStanzas.add(us);
    }

    @Override
    public Collection<UnknownStanza> getUnknownStanzas() {
        return this.unknownStanzas;
    }

    @Override
    public IdentifiedObject getObject(String id) {
        if (id == null || this.idHash == null) {
            return null;
        }
        IdentifiedObject out = this.idHash.get(id);
        if (out != null) {
            return out;
        }
        Matcher m = this.p.matcher(id);
        if (m.matches()) {
            String childID = m.group(1);
            String linkTypeStr = m.group(2);
            String typeID = m.group(3);
            String parentID = m.group(4);
            boolean completes = linkTypeStr.equals("~");
            IdentifiedObject childObj = childID.equals("null") ? null : this.idHash.get(childID);
            IdentifiedObject parentObj = parentID.equals("null") ? null : this.idHash.get(parentID);
            IdentifiedObject typeObj = typeID.equals("null") ? null : this.idHash.get(typeID);
            if (childObj instanceof LinkedObject && parentObj instanceof LinkedObject && typeObj instanceof OBOProperty) {
                for (Link link : ((LinkedObject)childObj).getParents()) {
                    if (!link.getType().equals(typeObj) || !link.getParent().equals(parentObj) || TermUtil.isIntersection(link) != completes) continue;
                    return new LinkLinkedObject(link);
                }
            }
        }
        return null;
    }

    @Override
    public ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    @Override
    public void addObject(IdentifiedObject obj) {
        this.idHash.put(obj.getID(), obj);
    }

    @Override
    public void removeObject(IdentifiedObject obj) {
        this.idHash.remove(obj.getID());
    }

    @Override
    public Collection<TermSubset> getSubsets() {
        return this.categories;
    }

    @Override
    public void addSubset(TermSubset cat) {
        this.categories.add(cat);
    }

    @Override
    public void removeCategory(TermSubset cat) {
        this.categories.remove(cat);
    }

    @Override
    public TermSubset getCategory(String name) {
        for (TermSubset cat : this.categories) {
            if (!cat.getName().equals(name)) continue;
            return cat;
        }
        return null;
    }

    @Override
    public Collection<SynonymType> getSynonymTypes() {
        return this.synonymCategories;
    }

    @Override
    public void addSynonymType(SynonymType cat) {
        this.synonymCategories.add(cat);
    }

    @Override
    public void removeSynonymCategory(SynonymType cat) {
        this.synonymCategories.remove(cat);
    }

    @Override
    public SynonymType getSynonymType(String id) {
        for (SynonymType cat : this.synonymCategories) {
            if (!cat.getID().equals(id)) continue;
            return cat;
        }
        return null;
    }

    protected void indexObject(IdentifiedObject o) {
        this.idHash.put(o.getID(), o);
    }

    @Override
    public Collection<IdentifiedObject> getObjects() {
        if (this.idHash == null) {
            return null;
        }
        return this.idHash.values();
    }

    private synchronized void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        serializingSession = this;
        in.defaultReadObject();
        serializingSession = null;
    }

    @Override
    public void removeUnknownStanza(UnknownStanza us) {
        this.unknownStanzas.remove(us);
    }

    @Override
    public HistoryItem importSession(OBOSession session, boolean executeNow) {
        if (executeNow) {
            for (IdentifiedObject identifiedObject : session.getObjects()) {
                if (this.idHash.containsKey(identifiedObject.getID())) {
                    IdentifiedObject curr = this.idHash.get(identifiedObject.getID());
                    if (!(curr instanceof DanglingObject)) continue;
                    this.addObject(identifiedObject);
                    continue;
                }
                if (this.idHash.containsKey(identifiedObject.getID())) continue;
                this.addObject(identifiedObject);
            }
            for (TermSubset termSubset : session.getSubsets()) {
                if (this.categories.contains(termSubset)) continue;
                this.addSubset(termSubset);
            }
            for (SynonymType synonymType : session.getSynonymTypes()) {
                if (this.synonymCategories.contains(synonymType)) continue;
                this.addSynonymType(synonymType);
            }
            for (Namespace namespace : session.getNamespaces()) {
                if (this.namespaces.contains(namespace)) continue;
                this.addNamespace(namespace);
            }
            TermUtil.resolveDanglingLinks(this);
            return null;
        }
        throw new UnsupportedOperationException("Undoable import not supported.");
    }

    @Override
    public OperationModel getOperationModel() {
        return this.operationModel;
    }

    @Override
    public QueryResolver getQueryResolver() {
        return null;
    }

    @Override
    public String getCurrentUser() {
        return this.currentUser;
    }

    @Override
    public void setCurrentUser(String currentUser) {
        this.currentUser = currentUser;
    }

    @Override
    public void addIDSpace(String idspace, String uriPrefix) {
        this.idspaceToUri.put(idspace, uriPrefix);
    }

    @Override
    public Collection<String> getIDSpaces() {
        return this.idspaceToUri.keySet();
    }

    @Override
    public String expandIDSpace(String idspace) {
        return this.idspaceToUri.get(idspace);
    }
}

