/*
 * Decompiled with CFR 0.152.
 */
package org.obo.datamodel.impl;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.IdentifiedObjectIndex;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.MutableLinkDatabase;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.impl.AbstractLinkDatabase;
import org.obo.datamodel.impl.DanglingLinkImpl;
import org.obo.datamodel.impl.DanglingObjectImpl;
import org.obo.datamodel.impl.OBORestrictionImpl;

public class SQLBackedMutableLinkDatabase
extends AbstractLinkDatabase
implements MutableLinkDatabase {
    protected static final Logger logger = Logger.getLogger(SQLBackedMutableLinkDatabase.class);
    protected String dbName = "ReasonerCache";
    protected Properties dbProperties = new Properties();
    protected Connection dbConnection = null;
    protected Statement stmt;
    protected IdentifiedObjectIndex index;
    protected static final String strCreateReasonerTable = "create table LINKS (    CHILD_ID          VARCHAR(30) NOT NULL,    TYPE_ID    VARCHAR(30) NOT NULL,     PARENT_ID   VARCHAR(30) NOT NULL,     constraint pk_iot_ primary key (CHILD_ID, TYPE_ID, PARENT_ID))";

    public SQLBackedMutableLinkDatabase(IdentifiedObjectIndex index) {
        this.initializeDatabase();
        this.setIdentifiedObjectIndex(index);
    }

    @Override
    public void setIdentifiedObjectIndex(IdentifiedObjectIndex index) {
        this.index = index;
    }

    protected void initializeDatabase() {
        String userHomeDir = System.getProperty("user.home", ".");
        String systemDir = userHomeDir + "/." + this.dbName;
        System.setProperty("database.system.home", systemDir);
        File fileSystemDir = new File(systemDir);
        fileSystemDir.mkdir();
        try {
            Class.forName("org.hsqldb.jdbcDriver");
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        this.initializeConnection(this.dbExists());
    }

    protected boolean createTables(Statement stmt) {
        boolean bCreatedTables = false;
        try {
            stmt.execute(strCreateReasonerTable);
            bCreatedTables = true;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return bCreatedTables;
    }

    protected boolean initializeConnection(boolean dbExists) {
        boolean bCreated = false;
        String dbUrl = this.getDatabaseURL();
        this.dbProperties.put("create", !dbExists + "");
        try {
            this.dbConnection = DriverManager.getConnection(dbUrl, this.dbProperties);
            this.dbConnection.setAutoCommit(true);
            this.stmt = this.dbConnection.createStatement();
            bCreated = this.createTables(this.stmt);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        this.dbProperties.remove("create");
        return bCreated;
    }

    public String getDatabaseURL() {
        return "jdbc:hsqldb:file:" + this.getDatabaseLocation();
    }

    public String getDatabaseLocation() {
        String dbLocation = System.getProperty("database.system.home");
        return dbLocation;
    }

    protected boolean dbExists() {
        boolean bExists = false;
        String dbLocation = this.getDatabaseLocation();
        File dbFileDir = new File(dbLocation);
        if (dbFileDir.exists()) {
            bExists = true;
        }
        return bExists;
    }

    @Override
    public void addObject(IdentifiedObject lo) {
    }

    public synchronized void clearObjectsAndAddParents(Collection<LinkedObject> clearUs, Collection<Link> links) {
        try {
            for (LinkedObject clearMe : clearUs) {
                this.stmt.execute("delete from LINKS where CHILD_ID = '" + clearMe.getID() + "'");
            }
            for (Link link : links) {
                this.stmt.execute("insert into LINKS values ('" + link.getChild().getID() + "', '" + link.getType().getID() + "', '" + link.getParent().getID() + "')");
            }
            this.dbConnection.commit();
        }
        catch (SQLException e) {
            logger.info((Object)"failed insert of multiple links");
            e.printStackTrace();
        }
    }

    public void addParents(Collection<Link> links) {
        try {
            for (Link link : links) {
                this.stmt.execute("insert into LINKS values ('" + link.getChild().getID() + "', '" + link.getType().getID() + "', '" + link.getParent().getID() + "')");
            }
            this.dbConnection.commit();
        }
        catch (SQLException e) {
            logger.info((Object)"failed insert of multiple links");
            e.printStackTrace();
        }
    }

    @Override
    public synchronized void addParent(Link link) {
        this.addParents(Collections.singleton(link));
    }

    @Override
    public synchronized void setParents(LinkedObject lo, Collection<Link> links) {
        try {
            this.stmt.execute("delete from LINKS where CHILD_ID = '" + lo.getID() + "'");
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        for (Link link : links) {
            try {
                this.stmt.execute("insert into LINKS values ('" + link.getChild().getID() + "', '" + link.getType().getID() + "', '" + link.getParent().getID() + "')");
            }
            catch (SQLException e) {
                logger.info((Object)("failed insert of " + link));
                e.printStackTrace();
            }
        }
        try {
            this.dbConnection.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized void clear() {
        try {
            this.stmt.execute("delete from LINKS");
            this.dbConnection.commit();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void removeObject(IdentifiedObject lo) {
    }

    @Override
    public synchronized void removeParent(Link link) {
        try {
            this.stmt.execute("delete from LINKS where CHILD_ID = '" + link.getChild().getID() + "' AND PARENT_ID = '" + link.getParent().getID() + "' AND TYPE_ID = '" + link.getType().getID() + "'");
            this.dbConnection.commit();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public synchronized Collection<Link> getChildren(LinkedObject lo) {
        LinkedList<Link> out = new LinkedList<Link>();
        try {
            ResultSet rs = this.stmt.executeQuery("select TYPE_ID, CHILD_ID from LINKS where PARENT_ID = '" + lo.getID() + "'");
            while (rs.next()) {
                String typeID = rs.getString("TYPE_ID");
                String childID = rs.getString("CHILD_ID");
                OBOProperty type = (OBOProperty)this.getObject(typeID);
                LinkedObject child = (LinkedObject)this.getObject(childID);
                if (type == null) {
                    System.err.println("** PULLED NULL TYPE FROM DATABASE ON ID " + typeID);
                }
                if (child == null) {
                    System.err.println("** PULLED NULL CHILD FROM DATABASE ON ID " + childID);
                }
                OBORestrictionImpl restriction = new OBORestrictionImpl(child, type, lo, true);
                out.add(restriction);
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return out;
    }

    @Override
    public Collection<IdentifiedObject> getObjects() {
        return null;
    }

    @Override
    public synchronized Collection<Link> getParents(LinkedObject lo) {
        LinkedList<Link> out = new LinkedList<Link>();
        boolean failed = false;
        do {
            try {
                failed = false;
                ResultSet rs = this.stmt.executeQuery("select PARENT_ID, TYPE_ID from LINKS where CHILD_ID = '" + lo.getID() + "'");
                if (rs == null) {
                    failed = true;
                    continue;
                }
                while (rs != null && rs.next()) {
                    String typeID = rs.getString("TYPE_ID");
                    String parentID = rs.getString("PARENT_ID");
                    OBOProperty type = (OBOProperty)this.getObject(typeID);
                    LinkedObject parent = (LinkedObject)this.getObject(parentID);
                    if (type == null) {
                        System.err.println("** PULLED NULL TYPE FROM DATABASE ON ID " + typeID);
                    }
                    if (parent == null) {
                        System.err.println("** PULLED NULL PARENT FROM DATABASE ON ID " + parentID);
                    }
                    out.add(new OBORestrictionImpl(lo, type, parent, true));
                }
            }
            catch (SQLException ex) {
                failed = true;
            }
        } while (failed);
        return out;
    }

    @Override
    public IdentifiedObject getObject(String id) {
        if (this.index != null) {
            IdentifiedObject out = this.index.getObject(id);
            if (out == null) {
                logger.info((Object)("$$$ GOT NULL LOOKUP ON " + id + " FROM INDEX " + this.index));
            }
            return out;
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        SQLBackedMutableLinkDatabase mldb = new SQLBackedMutableLinkDatabase(null);
        mldb.clear();
        mldb.addParent(new DanglingLinkImpl("GO:00001", "part_of", "GO:00005"));
        mldb.addParent(new DanglingLinkImpl("GO:00002", "part_of", "GO:00006"));
        mldb.addParent(new DanglingLinkImpl("GO:00003", "part_of", "GO:00007"));
        mldb.addParent(new DanglingLinkImpl("GO:00003", "part_of", "GO:00010"));
        mldb.addParent(new DanglingLinkImpl("GO:00004", "part_of", "GO:00008"));
        logger.info((Object)("parents of GO:00003 = " + mldb.getParents(new DanglingObjectImpl("GO:00003"))));
    }

    @Override
    public synchronized void clearParents(LinkedObject lo) {
        try {
            this.stmt.execute("delete from LINKS where CHILD_ID = '" + lo.getID() + "'");
            this.dbConnection.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public Collection<Link> getAncestors(LinkedObject lo) {
        return null;
    }
}

