/*
 * Decompiled with CFR 0.152.
 */
package org.obo.filters;

import java.util.Collection;
import org.apache.log4j.Logger;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.filters.Filter;
import org.obo.filters.LinkFilter;
import org.obo.filters.SearchAspect;
import org.obo.reasoner.ReasonedLinkDatabase;
import org.obo.reasoner.impl.TrimmedLinkDatabase;
import org.obo.util.TermUtil;

public class ChildSearchAspect
implements SearchAspect {
    protected static final Logger logger = Logger.getLogger(ChildSearchAspect.class);

    public Collection getObjects(Collection c, ReasonedLinkDatabase reasoner, Filter traversalFilter, Object o) {
        try {
            LinkedObject lo = (LinkedObject)o;
        }
        catch (ClassCastException e) {
            logger.debug((Object)("ChildSearchAspect.getObjects: can't cast " + o + ", class = " + o.getClass() + " to LinkedObject"));
            return c;
        }
        if (o instanceof LinkedObject) {
            if (reasoner != null) {
                TrimmedLinkDatabase trimmedReasoner = new TrimmedLinkDatabase(reasoner);
                for (Link link : trimmedReasoner.getChildren((LinkedObject)o)) {
                    if (traversalFilter != null && !traversalFilter.satisfies(link)) continue;
                    c.add(link.getChild());
                }
            } else {
                c.addAll(TermUtil.getChildren((LinkedObject)o, false, (LinkFilter)traversalFilter));
            }
        }
        return c;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return o.getClass().equals(this.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    @Override
    public String getID() {
        return "child";
    }

    public String toString() {
        return "Children";
    }

    @Override
    public boolean requiresReasoner() {
        return false;
    }
}

