/*
 * Decompiled with CFR 0.152.
 */
package org.obo.filters;

import java.util.Collection;
import org.apache.log4j.Logger;
import org.obo.datamodel.CommentedObject;
import org.obo.datamodel.IdentifiedObject;
import org.obo.filters.AbstractStringCriterion;

public class CommentSearchCriterion
extends AbstractStringCriterion {
    protected static final Logger logger = Logger.getLogger(CommentSearchCriterion.class);
    public static final CommentSearchCriterion CRITERION = new CommentSearchCriterion();
    protected boolean excludeObsoletes = false;

    public CommentSearchCriterion() {
        this(false);
    }

    public CommentSearchCriterion(boolean excludeObsoletes) {
        this.excludeObsoletes = excludeObsoletes;
    }

    @Override
    public Collection getValues(Collection scratch, Object obj) {
        if (!(!(obj instanceof CommentedObject) || this.excludeObsoletes && CommentSearchCriterion.isObsolete((IdentifiedObject)obj))) {
            scratch.add(((CommentedObject)obj).getComment());
        }
        return scratch;
    }

    @Override
    public String getID() {
        return "comment";
    }

    @Override
    public int getMinCardinality() {
        return 0;
    }

    @Override
    public int getMaxCardinality() {
        return 1;
    }

    @Override
    public Class getInputType() {
        return IdentifiedObject.class;
    }

    public String toString() {
        return "Comment";
    }
}

