/*
 * Decompiled with CFR 0.152.
 */
package org.obo.filters;

import java.util.Collection;
import org.apache.log4j.Logger;
import org.obo.datamodel.DbxrefedObject;
import org.obo.datamodel.DefinedObject;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Synonym;
import org.obo.datamodel.SynonymedObject;
import org.obo.filters.AbstractDbxrefSearchCriterion;

public class DbxrefSearchCriterion
extends AbstractDbxrefSearchCriterion<IdentifiedObject> {
    protected static final Logger logger = Logger.getLogger(DbxrefSearchCriterion.class);
    protected boolean excludeObsoletes = false;

    public DbxrefSearchCriterion() {
        this(false);
    }

    public DbxrefSearchCriterion(boolean excludeObsoletes) {
        this.excludeObsoletes = excludeObsoletes;
    }

    @Override
    protected void addDbxrefs(Collection scratch, IdentifiedObject obj) {
        if (this.excludeObsoletes && obj instanceof IdentifiedObject && DbxrefSearchCriterion.isObsolete(obj)) {
            return;
        }
        if (obj instanceof DbxrefedObject) {
            this.addDbxrefs(scratch, ((DbxrefedObject)((Object)obj)).getDbxrefs());
        }
        if (obj instanceof DefinedObject) {
            this.addDbxrefs(scratch, ((DefinedObject)obj).getDefDbxrefs());
        }
        if (obj instanceof SynonymedObject) {
            for (Synonym s : ((SynonymedObject)obj).getSynonyms()) {
                this.addDbxrefs(scratch, s.getXrefs());
            }
        }
    }

    @Override
    public String getID() {
        return "dbxref";
    }

    @Override
    public String toString() {
        return "Dbxref";
    }

    @Override
    public Class<IdentifiedObject> getInputType() {
        return IdentifiedObject.class;
    }
}

