/*
 * Decompiled with CFR 0.152.
 */
package org.obo.filters;

import java.util.Collection;
import org.apache.log4j.Logger;
import org.obo.filters.AbstractComparison;

public class EqualsComparison
extends AbstractComparison {
    protected static final Logger logger = Logger.getLogger(EqualsComparison.class);
    protected Class[] types = new Class[]{String.class, Number.class};

    @Override
    public Class[] getAcceptedTypes() {
        return this.types;
    }

    @Override
    public String getID() {
        return "=";
    }

    @Override
    public boolean matches(Collection testVals, String value) {
        if (value == null) {
            value = "";
        }
        Double intVal = null;
        try {
            intVal = new Double(value);
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        for (Object o : testVals) {
            boolean returnVal = false;
            if (o instanceof Number && intVal != null) {
                returnVal = o.equals(intVal);
            } else if (o instanceof String) {
                returnVal = ((String)o).equalsIgnoreCase(value);
            }
            if (!returnVal) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "equals";
    }
}

