/*
 * Decompiled with CFR 0.152.
 */
package org.obo.filters;

import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.MultiIDObject;
import org.obo.filters.AbstractStringCriterion;

public class IDSearchCriterion
extends AbstractStringCriterion {
    protected static final Logger logger = Logger.getLogger(IDSearchCriterion.class);
    protected boolean excludeObsoletes = false;
    protected String id = "id";

    public IDSearchCriterion() {
        this(false);
    }

    public IDSearchCriterion(boolean excludeObsoletes) {
        this.excludeObsoletes = excludeObsoletes;
    }

    public IDSearchCriterion(boolean excludeObsoletes, String ID) {
        this.excludeObsoletes = excludeObsoletes;
        this.id = ID;
    }

    @Override
    public Collection getValues(Collection scratch, Object obj) {
        if (this.excludeObsoletes && IDSearchCriterion.isObsolete((IdentifiedObject)obj)) {
            return scratch;
        }
        scratch.add(((IdentifiedObject)obj).getID());
        if (obj instanceof MultiIDObject) {
            Iterator<String> it = ((MultiIDObject)obj).getSecondaryIDs().iterator();
            while (it.hasNext()) {
                scratch.add(it.next());
            }
        }
        return scratch;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public Class getInputType() {
        return IdentifiedObject.class;
    }

    public String toString() {
        return "ID";
    }
}

