/*
 * Decompiled with CFR 0.152.
 */
package org.obo.filters;

import java.util.Iterator;
import org.apache.log4j.Logger;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOProperty;
import org.obo.filters.AbstractBooleanCriterion;

public class IsaCompleteCriterion
extends AbstractBooleanCriterion {
    protected static final Logger logger = Logger.getLogger(IsaCompleteCriterion.class);

    @Override
    public String getID() {
        return "is_isa_complete";
    }

    @Override
    public boolean matches(IdentifiedObject o) {
        if (o instanceof LinkedObject) {
            return this.isIsaComplete((LinkedObject)o);
        }
        return true;
    }

    protected boolean isIsaComplete(LinkedObject lo) {
        if (lo.getParents().size() == 0) {
            return true;
        }
        Iterator<Link> it = lo.getParents().iterator();
        int n = 0;
        while (it.hasNext()) {
            Link link = it.next();
            if (link.getType().equals(OBOProperty.IS_A) && this.isIsaComplete(link.getParent())) {
                return true;
            }
            if (link.getType().equals(OBOProperty.DISJOINT_FROM)) continue;
            ++n;
        }
        return n == 0;
    }

    public String toString() {
        return "Is is_a complete";
    }
}

