/*
 * Decompiled with CFR 0.152.
 */
package org.obo.filters;

import java.util.Collection;
import org.apache.log4j.Logger;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOProperty;
import org.obo.filters.AbstractNumberCriterion;
import org.obo.util.TermUtil;

public class IsaParentCountCriterion
extends AbstractNumberCriterion {
    protected static final Logger logger = Logger.getLogger(IsaParentCountCriterion.class);

    @Override
    public Collection getValues(Collection scratch, Object obj) {
        IdentifiedObject o = (IdentifiedObject)obj;
        int count = 0;
        if (o instanceof LinkedObject && !TermUtil.isObsolete(o)) {
            for (Link link : ((LinkedObject)o).getParents()) {
                if (!link.getType().equals(OBOProperty.IS_A)) continue;
                ++count;
            }
        }
        scratch.add(new Integer(count));
        return scratch;
    }

    @Override
    public String getID() {
        return "isa_parent_count";
    }

    @Override
    public Class getInputType() {
        return IdentifiedObject.class;
    }

    public String toString() {
        return "is_a parent count";
    }
}

