/*
 * Decompiled with CFR 0.152.
 */
package org.obo.filters;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.obo.filters.AbstractFilterEditor;
import org.obo.filters.AllTextFieldsCriterion;
import org.obo.filters.CompoundEditable;
import org.obo.filters.CompoundFilter;
import org.obo.filters.CompoundFilterImpl;
import org.obo.filters.ContainsComparison;
import org.obo.filters.Filter;
import org.obo.filters.FilterFactory;
import org.obo.filters.KeywordSearchCriterion;
import org.obo.filters.LinkFilter;
import org.obo.filters.ObjectFilter;
import org.obo.filters.ObjectFilterImpl;

public class KeywordFilterBuilder
extends AbstractFilterEditor
implements CompoundEditable {
    protected static final Logger logger = Logger.getLogger(KeywordFilterBuilder.class);
    private static final long serialVersionUID = 1L;
    protected JTextField textField = new JTextField();
    protected Filter filter;

    public KeywordFilterBuilder() {
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, 1));
        this.add(Box.createVerticalGlue());
        this.add(this.textField);
        this.add(Box.createVerticalGlue());
    }

    @Override
    public void setShowCompoundFilter(boolean showCompoundFilter) {
    }

    @Override
    public void setFilterFactory(FilterFactory filterFactory) {
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.textField.addActionListener(listener);
    }

    @Override
    public void removeActionListener(ActionListener listener) {
        this.textField.addActionListener(listener);
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    protected void populateList(Collection c, Filter filter) {
        if (filter instanceof CompoundFilter) {
            this.populateList(c, (CompoundFilter)filter);
        } else if (filter instanceof LinkFilter) {
            this.populateList(c, (LinkFilter)filter);
        } else if (filter instanceof ObjectFilter) {
            this.populateList(c, (ObjectFilter)filter);
        } else {
            logger.info((Object)("what do I do with " + filter.getClass()));
        }
    }

    protected void populateList(Collection c, CompoundFilter filter) {
        for (Filter<?> f : filter.getFilters()) {
            this.populateList(c, f);
        }
    }

    protected void populateList(Collection c, LinkFilter filter) {
        this.populateList(c, filter.getFilter());
    }

    protected void populateList(Collection c, ObjectFilter filter) {
        c.add(filter.getValue());
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = filter;
        if (filter == null) {
            this.textField.setText("");
            return;
        }
        LinkedList vals = new LinkedList();
        this.populateList(vals, filter);
        StringBuffer out = new StringBuffer();
        boolean first = true;
        for (String s : vals) {
            if (first) {
                out.append(s);
            } else {
                out.append(" ");
                out.append(s);
            }
            first = false;
        }
        this.textField.setText(out.toString());
    }

    protected Collection unescapeValues(String string) {
        LinkedList out = new LinkedList();
        KeywordSearchCriterion.extractKeywords(out, string);
        return out;
    }

    @Override
    public void acceptEdits() {
        CompoundFilterImpl cf = new CompoundFilterImpl();
        cf.setBooleanOperation(0);
        Collection c = this.unescapeValues(this.textField.getText());
        if (c.size() > 0) {
            for (String s : c) {
                ObjectFilterImpl f = new ObjectFilterImpl();
                f.setCriterion(new KeywordSearchCriterion());
                f.setComparison(new ContainsComparison());
                f.setValue(s);
                cf.addFilter(f);
            }
        } else {
            ObjectFilterImpl f = new ObjectFilterImpl();
            f.setCriterion(new AllTextFieldsCriterion());
            f.setComparison(new ContainsComparison());
            f.setValue("");
            cf.addFilter(f);
        }
        this.filter = cf;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.textField != null) {
            this.textField.setFont(font);
            this.textField.setMaximumSize(new Dimension(Integer.MAX_VALUE, font.getSize() + 20));
        }
    }

    @Override
    public void setButtonColor(Color buttonColor) {
    }
}

