/*
 * Decompiled with CFR 0.152.
 */
package org.obo.filters;

import org.apache.log4j.Logger;
import org.bbop.expression.JexlContext;
import org.obo.datamodel.Link;
import org.obo.datamodel.OBOProperty;
import org.obo.filters.EqualsComparison;
import org.obo.filters.IDSearchCriterion;
import org.obo.filters.LinkFilter;
import org.obo.filters.ObjectFilter;
import org.obo.filters.ObjectFilterImpl;
import org.obo.filters.SelfSearchAspect;
import org.obo.reasoner.ReasonedLinkDatabase;

public class LinkFilterImpl
implements LinkFilter {
    protected static final Logger logger = Logger.getLogger(LinkFilterImpl.class);
    private static final long serialVersionUID = 1L;
    protected int aspect = 2;
    protected ObjectFilter filter = new ObjectFilterImpl();
    protected JexlContext context;

    public LinkFilterImpl() {
    }

    public LinkFilterImpl(OBOProperty p) {
        ObjectFilterImpl typeFilter = new ObjectFilterImpl();
        typeFilter.setCriterion(new IDSearchCriterion());
        typeFilter.setAspect(new SelfSearchAspect());
        typeFilter.setComparison(new EqualsComparison());
        typeFilter.setValue(p.getID());
        this.setAspect(2);
        this.setFilter(typeFilter);
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public void setContext(JexlContext context) {
        this.context = context;
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        if (this.aspect == 1) {
            out.append("Link child");
        } else if (this.aspect == 3) {
            out.append("Link parent");
        } else if (this.aspect == 2) {
            out.append("Link type");
        } else {
            out.append("Link");
        }
        out.append(" has ");
        out.append(this.filter.toString());
        return out.toString();
    }

    @Override
    public int getAspect() {
        return this.aspect;
    }

    @Override
    public void setAspect(int aspect) {
        this.aspect = aspect;
    }

    @Override
    public ObjectFilter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(ObjectFilter filter) {
        this.filter = filter;
    }

    @Override
    public boolean satisfies(Link link) {
        if (this.aspect == 1 && link.getChild() != null) {
            return this.filter.satisfies(link.getChild());
        }
        if (this.aspect == 3 && link.getParent() != null) {
            return this.filter.satisfies(link.getParent());
        }
        if (this.aspect == 2 && link.getType() != null) {
            return this.filter.satisfies(link.getType());
        }
        if (this.aspect == 4) {
            return this.filter.satisfies(link);
        }
        return false;
    }

    @Override
    public void setReasoner(ReasonedLinkDatabase reasoner) {
        this.filter.setReasoner(reasoner);
    }
}

