/*
 * Decompiled with CFR 0.152.
 */
package org.obo.filters;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.apache.log4j.Logger;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.RootAlgorithm;
import org.obo.datamodel.impl.DefaultLinkDatabase;
import org.obo.filters.AbstractBooleanCriterion;
import org.obo.util.TermUtil;

public class MultipleRootSearchCriterion
extends AbstractBooleanCriterion {
    protected static final Logger logger = Logger.getLogger(MultipleRootSearchCriterion.class);
    public static final MultipleRootSearchCriterion CRITERION = new MultipleRootSearchCriterion();

    @Override
    public boolean matches(IdentifiedObject o) {
        block7: {
            if (!(o instanceof LinkedObject)) break block7;
            if (this.reasoner != null) {
                Collection<Link> parentLinks = this.reasoner.getParents((LinkedObject)o);
                RootAlgorithm.GREEDY.setLinkDatabase(this.reasoner);
                int rootCount = 0;
                LinkedHashSet<LinkedObject> parentSet = new LinkedHashSet<LinkedObject>();
                for (Link link : parentLinks) {
                    parentSet.add(link.getParent());
                }
                for (LinkedObject obj : parentSet) {
                    if (RootAlgorithm.GREEDY.isRoot(obj)) {
                        ++rootCount;
                    }
                    if (rootCount <= 1) continue;
                    return true;
                }
            } else {
                Collection<LinkedObject> parents = TermUtil.getAncestors((LinkedObject)o, null);
                int rootCount = 0;
                DefaultLinkDatabase linkDB = new DefaultLinkDatabase(null);
                RootAlgorithm.GREEDY.setLinkDatabase(linkDB);
                for (LinkedObject lo : parents) {
                    if (RootAlgorithm.GREEDY.isRoot(lo)) {
                        ++rootCount;
                    }
                    if (rootCount <= 1) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public String getID() {
        return "multiple_roots";
    }

    public String toString() {
        return "Has multiple roots";
    }
}

