/*
 * Decompiled with CFR 0.152.
 */
package org.obo.filters;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.bbop.expression.ExpressionException;
import org.bbop.expression.ExpressionUtil;
import org.bbop.expression.JexlContext;
import org.obo.datamodel.LinkedObject;
import org.obo.filters.AbstractNumberCriterion;
import org.obo.filters.AllTextFieldsCriterion;
import org.obo.filters.BooleanCriterion;
import org.obo.filters.ContainsComparison;
import org.obo.filters.LinkFilter;
import org.obo.filters.ObjectFilter;
import org.obo.filters.SearchAspect;
import org.obo.filters.SearchComparison;
import org.obo.filters.SearchCriterion;
import org.obo.filters.SelfSearchAspect;
import org.obo.filters.StringConverter;
import org.obo.filters.StringCriterionWrapper;
import org.obo.reasoner.ReasonedLinkDatabase;

public class ObjectFilterImpl
implements ObjectFilter {
    protected static final Logger logger = Logger.getLogger(ObjectFilterImpl.class);
    private static final long serialVersionUID = 1L;
    protected JexlContext context;
    protected boolean negate = false;
    protected LinkFilter traversalFilter;
    protected SearchAspect aspect = new SelfSearchAspect();
    protected boolean excludeObsoletes = false;
    protected SearchCriterion<?, ?> criterion = new AllTextFieldsCriterion();
    protected SearchCriterion wrappedCriterion = new StringCriterionWrapper(this.criterion, StringConverter.DEFAULT);
    protected SearchComparison comparison = new ContainsComparison();
    protected String value = "";
    public static long allocTime = 0L;
    protected ReasonedLinkDatabase reasoner;

    public ObjectFilterImpl() {
        this(false);
    }

    public ObjectFilterImpl(boolean excludeObsoletes) {
        this.excludeObsoletes = excludeObsoletes;
        this.criterion = new AllTextFieldsCriterion(excludeObsoletes);
    }

    public int hashCode() {
        return this.aspect.hashCode() + this.criterion.hashCode() + this.comparison.hashCode() + this.value.hashCode() + (this.negate ? 1 : 0);
    }

    @Override
    public void setContext(JexlContext context) {
        this.context = context;
    }

    public void lock() {
        try {
            this.value = ExpressionUtil.resolveBacktickExpression((String)this.value, (JexlContext)this.context);
        }
        catch (ExpressionException ex) {
            ex.printStackTrace();
        }
    }

    public boolean equals(Object o) {
        if (o instanceof ObjectFilter) {
            ObjectFilter filter = (ObjectFilter)o;
            return filter.getAspect().getClass().equals(this.aspect.getClass()) && filter.getCriterion().getClass().equals(this.criterion.getClass()) && filter.getComparison().getClass().equals(this.comparison.getClass()) && filter.getValue().equals(this.value);
        }
        return false;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public ReasonedLinkDatabase getReasoner() {
        return this.reasoner;
    }

    @Override
    public void setReasoner(ReasonedLinkDatabase reasoner) {
        this.reasoner = reasoner;
    }

    @Override
    public boolean satisfies(Object object) {
        if (this.criterion == null) {
            return false;
        }
        if (!this.criterion.getInputType().isAssignableFrom(object.getClass())) {
            return false;
        }
        String matchVal = this.value;
        try {
            matchVal = ExpressionUtil.resolveBacktickExpression((String)this.value, (JexlContext)this.context);
        }
        catch (ExpressionException e) {
            logger.debug((Object)"ObjectFilterImpl -- matchVal error");
        }
        LinkedList<LinkedObject> os = new LinkedList<LinkedObject>();
        this.aspect.getObjects(os, this.getReasoner(), this.traversalFilter, object);
        this.criterion.setReasoner(this.getReasoner());
        boolean matches = this.negate;
        for (Object e : os) {
            if (this.criterion instanceof BooleanCriterion) {
                if (!((BooleanCriterion)this.criterion).matches(e)) continue;
                matches = !this.negate;
                break;
            }
            LinkedList c = new LinkedList();
            boolean b = false;
            Collection values = this.criterion instanceof AbstractNumberCriterion ? ((AbstractNumberCriterion)this.criterion).getValues(c, e) : this.wrappedCriterion.getValues(c, e);
            b = this.comparison.matches(values, matchVal);
            if (!b) continue;
            matches = !this.negate;
            break;
        }
        return matches;
    }

    public String toString() {
        if (this.criterion instanceof BooleanCriterion) {
            return (this.negate ? "NOT " : "") + (this.aspect instanceof SelfSearchAspect ? "" : this.aspect.toString() + " ") + this.criterion;
        }
        return (this.negate ? "NOT " : "") + (this.aspect instanceof SelfSearchAspect ? "" : this.aspect.toString() + " ") + this.criterion + " " + this.comparison + " \"" + this.value + "\"";
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public SearchComparison getComparison() {
        return this.comparison;
    }

    @Override
    public void setComparison(SearchComparison comparison) {
        this.comparison = comparison;
    }

    @Override
    public SearchAspect getAspect() {
        return this.aspect;
    }

    @Override
    public void setAspect(SearchAspect aspect) {
        this.aspect = aspect;
    }

    @Override
    public SearchCriterion getCriterion() {
        return this.criterion;
    }

    @Override
    public void setCriterion(SearchCriterion criterion) {
        this.criterion = criterion;
        this.wrappedCriterion = new StringCriterionWrapper(criterion, StringConverter.DEFAULT);
    }

    @Override
    public boolean getNegate() {
        return this.negate;
    }

    @Override
    public void setNegate(boolean negate) {
        this.negate = negate;
    }

    @Override
    public LinkFilter getTraversalFilter() {
        return this.traversalFilter;
    }

    @Override
    public void setTraversalFilter(LinkFilter traversalFilter) {
        this.traversalFilter = traversalFilter;
    }
}

