/*
 * Decompiled with CFR 0.152.
 */
package org.obo.history;

import java.util.Collection;
import org.apache.log4j.Logger;
import org.bbop.util.ObjectUtil;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOProperty;
import org.obo.history.DefaultHistoryList;
import org.obo.history.HistoryItem;
import org.obo.history.HistoryList;

public class CreateIntersectionLinkHistoryItem
extends HistoryItem {
    protected static final Logger logger = Logger.getLogger(CreateIntersectionLinkHistoryItem.class);
    private static final long serialVersionUID = -3796745679067017708L;
    protected String typeID;
    protected String parentID;

    public CreateIntersectionLinkHistoryItem() {
    }

    public CreateIntersectionLinkHistoryItem(Link link) {
        this(link.getChild(), link.getType(), link.getParent());
    }

    public CreateIntersectionLinkHistoryItem(String child, String type, String parent) {
        this.target = child;
        this.typeID = type;
        this.parentID = parent;
    }

    public CreateIntersectionLinkHistoryItem(LinkedObject child, OBOProperty type, LinkedObject parent) {
        this(child.getID(), type.getID(), parent.getID());
    }

    public boolean equals(Object o) {
        if (!(o instanceof CreateIntersectionLinkHistoryItem)) {
            return false;
        }
        CreateIntersectionLinkHistoryItem item = (CreateIntersectionLinkHistoryItem)o;
        return ObjectUtil.equals((Object)this.target, (Object)item.getTarget()) && ObjectUtil.equals((Object)this.typeID, (Object)item.getTypeID()) && ObjectUtil.equals((Object)this.parentID, (Object)item.getParentID());
    }

    @Override
    public String getShortName() {
        return "created link";
    }

    public String toString() {
        return "Created link " + this.target + " -" + this.typeID + "-> " + this.parentID;
    }

    public String getParentID() {
        return this.parentID;
    }

    public String getTypeID() {
        return this.typeID;
    }

    @Override
    public HistoryList forwardID(String oldID, Collection newIDs) {
        if (ObjectUtil.equals((Object)this.target, (Object)oldID) || ObjectUtil.equals((Object)this.typeID, (Object)oldID) || ObjectUtil.equals((Object)this.parentID, (Object)oldID)) {
            DefaultHistoryList out = new DefaultHistoryList();
            for (Object oid : newIDs) {
                String id = (String)oid;
                String newChildID = this.target;
                String newTypeID = this.typeID;
                String newParentID = this.parentID;
                if (ObjectUtil.equals((Object)newChildID, (Object)oldID)) {
                    newChildID = id;
                }
                if (ObjectUtil.equals((Object)newTypeID, (Object)oldID)) {
                    newTypeID = id;
                }
                if (ObjectUtil.equals((Object)newParentID, (Object)oldID)) {
                    newParentID = id;
                }
                out.addItem(new CreateIntersectionLinkHistoryItem(newChildID, newTypeID, newParentID));
            }
            return out;
        }
        return null;
    }

    public void setParentID(String parentID) {
        this.parentID = parentID;
    }

    public void setTypeID(String typeID) {
        this.typeID = typeID;
    }
}

