/*
 * Decompiled with CFR 0.152.
 */
package org.obo.history;

import java.util.Collection;
import org.apache.log4j.Logger;
import org.bbop.util.ObjectUtil;
import org.obo.datamodel.OBOProperty;
import org.obo.history.HistoryItem;
import org.obo.history.HistoryList;

public class CyclicHistoryItem
extends HistoryItem {
    protected static final Logger logger = Logger.getLogger(CyclicHistoryItem.class);
    private static final long serialVersionUID = -7013371178175196469L;
    protected boolean oldCyclic;

    public CyclicHistoryItem(OBOProperty target) {
        this(target.getID(), target.isCyclic());
    }

    public CyclicHistoryItem() {
        this(null, false);
    }

    public CyclicHistoryItem(String target, boolean oldCyclic) {
        this.target = target;
        this.oldCyclic = oldCyclic;
    }

    public int hashCode() {
        return CyclicHistoryItem.getHash(this.target) ^ CyclicHistoryItem.getHash(this.oldCyclic);
    }

    public boolean equals(Object o) {
        if (!(o instanceof CyclicHistoryItem)) {
            return false;
        }
        CyclicHistoryItem item = (CyclicHistoryItem)o;
        return ObjectUtil.equals((Object)this.target, (Object)item.getTarget()) && this.oldCyclic == item.getOldCyclic();
    }

    public void setOldCyclic(boolean oldCyclic) {
        this.oldCyclic = oldCyclic;
    }

    public boolean getOldCyclic() {
        return this.oldCyclic;
    }

    @Override
    public String getShortName() {
        return "changed is cyclic";
    }

    public String toString() {
        return "changed \"is cyclic\" status of " + this.target + " to " + !this.oldCyclic;
    }

    @Override
    public HistoryList forwardID(String oldID, Collection newIDs) {
        return null;
    }
}

