/*
 * Decompiled with CFR 0.152.
 */
package org.obo.history;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.obo.history.HistoryItem;
import org.obo.history.HistoryList;
import org.obo.history.SessionHistoryList;

public class DefaultHistoryList
implements SessionHistoryList {
    protected static final Logger logger = Logger.getLogger(DefaultHistoryList.class);
    private static final long serialVersionUID = 6140971918384400136L;
    protected String user;
    protected Date date;
    protected String version;
    protected String comment;
    protected String title;
    protected List<HistoryItem> historyList = new LinkedList<HistoryItem>();
    protected List warnings = new Vector();

    public DefaultHistoryList() {
        this.date = new Date();
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    public List getWarnings() {
        return this.warnings;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public void setDate(Date date) {
        this.date = date;
    }

    @Override
    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public Collection<HistoryItem> getHistoryItems() {
        return this.historyList;
    }

    @Override
    public HistoryItem getItemAt(int index) {
        return this.historyList.get(index);
    }

    @Override
    public int getIndex(HistoryItem item) {
        return this.historyList.indexOf(item);
    }

    @Override
    public int size() {
        return this.historyList.size();
    }

    @Override
    public void addItem(HistoryItem item) {
        this.historyList.add(item);
    }

    @Override
    public void addItems(Collection<HistoryItem> items) {
        for (HistoryItem item : items) {
            this.historyList.add(item);
        }
    }

    @Override
    public void removeItem(HistoryItem item) {
        this.historyList.remove(item);
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getTitle() {
        if (this.title != null) {
            return this.title;
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat("hh:mm aaa, MMMMM dd, yyyy");
            return "Saved by " + this.user + " at " + format.format(this.date);
        }
        catch (Exception e) {
            return "History";
        }
    }

    public String toString() {
        return this.getTitle();
    }

    @Override
    public HistoryList forwardID(String oldID, Collection newIDs) {
        HistoryList out = null;
        Iterator<HistoryItem> it = this.historyList.iterator();
        int i = 0;
        while (it.hasNext()) {
            HistoryItem item = it.next();
            HistoryList itemList = item.forwardID(oldID, newIDs);
            if (itemList == null) {
                if (out != null) {
                    out.addItem(item);
                }
            } else {
                if (out == null) {
                    out = new DefaultHistoryList();
                    for (int j = 0; j < i; ++j) {
                        out.addItem(this.historyList.get(j));
                    }
                }
                for (HistoryItem hi : itemList.getHistoryItems()) {
                    out.addItem(hi);
                }
            }
            ++i;
        }
        return out;
    }
}

