/*
 * Decompiled with CFR 0.152.
 */
package org.obo.history;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.bbop.util.ObjectUtil;
import org.obo.datamodel.Link;
import org.obo.datamodel.OBORestriction;
import org.obo.history.DefaultHistoryList;
import org.obo.history.HistoryList;
import org.obo.history.StringRelationship;

public abstract class HistoryItem
implements Serializable,
Cloneable {
    protected static final Logger logger = Logger.getLogger(HistoryItem.class);
    protected String target;
    protected HashSet edited = new HashSet();
    protected HashSet editedTerms = new HashSet();
    protected boolean isUndoable = true;
    protected Map properties;

    public static StringRelationship createStringRelationship(Link link) {
        if (link instanceof OBORestriction) {
            return new StringRelationship((OBORestriction)link);
        }
        return new StringRelationship(link.getChild(), link.getType(), link.getParent(), false, false, false, null, null, null, link.getNamespace().getID());
    }

    public void setProperty(Object key, Object value) {
        if (this.properties == null) {
            this.properties = this.createProperties();
        }
        this.properties.put(key, value);
    }

    protected Map<?, ?> createProperties() {
        return new HashMap();
    }

    public Object getProperty(Object key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(key);
    }

    public static int getHash(boolean b) {
        if (b) {
            return Boolean.TRUE.hashCode();
        }
        return Boolean.FALSE.hashCode();
    }

    public static int getHash(Object o) {
        if (o == null) {
            return 0;
        }
        return o.hashCode();
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getTarget() {
        return this.target;
    }

    public boolean isUndoable() {
        return this.isUndoable;
    }

    public abstract String getShortName();

    public Set getEditedNodes() {
        return (Set)this.edited.clone();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public static HistoryList defaultForwardID(HistoryItem item, String oldID, Collection<String> newIDs) {
        if (ObjectUtil.equals((Object)item.getTarget(), (Object)oldID)) {
            DefaultHistoryList out = new DefaultHistoryList();
            for (String id : newIDs) {
                HistoryItem newitem = (HistoryItem)item.clone();
                newitem.setTarget(id);
                out.addItem(newitem);
            }
            return out;
        }
        return null;
    }

    public abstract HistoryList forwardID(String var1, Collection var2);

    public Set getEditedTerms() {
        if (this.target != null) {
            this.editedTerms.add(this.target);
        }
        return (Set)this.editedTerms.clone();
    }
}

