/*
 * Decompiled with CFR 0.152.
 */
package org.obo.history;

import java.io.Serializable;
import org.apache.log4j.Logger;
import org.bbop.util.ObjectUtil;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.OBORestriction;

public class StringRelationship
implements Serializable,
Cloneable {
    protected static final Logger logger = Logger.getLogger(StringRelationship.class);
    private static final long serialVersionUID = 1L;
    protected String parent;
    protected String child;
    protected String type;
    protected boolean completes;
    protected boolean necessary = true;
    protected boolean inverse_necessary;
    protected Integer cardinality;
    protected Integer minCardinality;
    protected Integer maxCardinality;
    protected String ns;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    public String getNamespace() {
        return this.ns;
    }

    public void setCompletes(boolean completes) {
        this.completes = completes;
    }

    public boolean completes() {
        return this.completes;
    }

    public boolean isNecessary() {
        return this.necessary;
    }

    public boolean isInverseNecessary() {
        return this.inverse_necessary;
    }

    public Integer getCardinality() {
        return this.cardinality;
    }

    public Integer getMinCardinality() {
        return this.minCardinality;
    }

    public Integer getMaxCardinality() {
        return this.maxCardinality;
    }

    public StringRelationship() {
    }

    public StringRelationship(OBORestriction rel) {
        this(rel.getChild(), rel.getType(), rel.getParent(), rel.getCompletes(), rel.isNecessarilyTrue(), rel.isInverseNecessarilyTrue(), rel.getCardinality(), rel.getMinCardinality(), rel.getMaxCardinality(), rel.getNamespace() == null ? null : rel.getNamespace().getID());
    }

    public StringRelationship(Link rel) {
        this(rel.getChild(), rel.getType(), rel.getParent(), false, false, false, null, null, null, rel.getNamespace() == null ? null : rel.getNamespace().getID());
    }

    public StringRelationship(LinkedObject childTerm, OBOProperty typeTerm, LinkedObject parentTerm) {
        this(childTerm, typeTerm, parentTerm, false, true, false, null, null, null, null);
    }

    public StringRelationship(LinkedObject childTerm, OBOProperty typeTerm, LinkedObject parentTerm, boolean completes, boolean necessary, boolean inverse_necessary, Integer cardinality, Integer minCardinality, Integer maxCardinality, String ns) {
        this(childTerm == null ? null : childTerm.getID(), typeTerm == null ? null : typeTerm.getID(), parentTerm == null ? null : parentTerm.getID(), completes, necessary, inverse_necessary, cardinality, minCardinality, maxCardinality, ns);
    }

    public StringRelationship(String child, String type, String parent) {
        this(child, type, parent, false, true, false, null, null, null, null);
    }

    public StringRelationship(String child, String type, String parent, boolean completes) {
        this(child, type, parent, completes, false, false, null, null, null, null);
    }

    public StringRelationship(String child, String type, String parent, boolean completes, boolean necessary, boolean inverse_necessary, Integer cardinality, Integer minCardinality, Integer maxCardinality, String ns) {
        this.parent = parent;
        this.child = child;
        this.type = type;
        this.completes = completes;
        this.necessary = necessary;
        this.inverse_necessary = inverse_necessary;
        this.cardinality = cardinality;
        this.minCardinality = minCardinality;
        this.maxCardinality = maxCardinality;
        this.ns = ns;
    }

    public boolean equals(Object o) {
        StringRelationship sr = (StringRelationship)o;
        return ObjectUtil.equals((Object)this.parent, (Object)sr.getParent()) && ObjectUtil.equals((Object)this.child, (Object)sr.getChild()) && ObjectUtil.equals((Object)this.type, (Object)sr.getType());
    }

    public int hashCode() {
        return (this.parent == null ? 0 : this.parent.hashCode()) ^ (this.child == null ? 0 : this.child.hashCode()) ^ (this.type == null ? 0 : this.type.hashCode());
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public void setChild(String child) {
        this.child = child;
    }

    public void setType(String type) {
        this.type = type;
    }

    public StringRelationship(String parent) {
        this(parent, null, null, false, false, false, null, null, null, null);
    }

    public String getParent() {
        return this.parent;
    }

    public String getChild() {
        return this.child;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return this.child + " --" + this.type + "--> " + this.parent;
    }

    public boolean canForward(String oldID) {
        boolean forwarded = false;
        if (this.parent != null && this.parent.equals(oldID)) {
            forwarded = true;
        }
        if (this.child != null && this.child.equals(oldID)) {
            forwarded = true;
        }
        if (this.type != null && this.type.equals(oldID)) {
            forwarded = true;
        }
        return forwarded;
    }

    public boolean forwardID(String oldID, String newID) {
        boolean forwarded = false;
        if (this.parent != null && this.parent.equals(oldID)) {
            this.setParent(newID);
            forwarded = true;
        }
        if (this.child != null && this.child.equals(oldID)) {
            this.setChild(newID);
            forwarded = true;
        }
        if (this.type != null && this.type.equals(oldID)) {
            forwarded = true;
            this.setType(newID);
        }
        return forwarded;
    }
}

