/*
 * Decompiled with CFR 0.152.
 */
package org.obo.identifier;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.obo.datamodel.IdentifiableObject;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.MultiIDObject;
import org.obo.datamodel.OBOSession;
import org.obo.datamodel.impl.NamedIDProfile;
import org.obo.identifier.IDGenerator;
import org.obo.identifier.IDProfile;
import org.obo.identifier.IDRule;
import org.obo.util.IDUtil;

public class DefaultIDGenerator
implements IDGenerator {
    protected static final Logger logger = Logger.getLogger(DefaultIDGenerator.class);
    protected IDProfile profile;
    protected IDProfile defaultProfile = new NamedIDProfile("<default profile>");

    protected static List matchSequence(String s, List sequence, LinkedObject lo) {
        LinkedList<IDUtil.VariableValue> out = new LinkedList<IDUtil.VariableValue>();
        for (Object o : sequence) {
            if (o instanceof String) {
                if (!s.startsWith((String)o)) {
                    return null;
                }
                s = s.substring(((String)o).length(), s.length());
                continue;
            }
            if (!(o instanceof IDUtil.Variable)) continue;
            IDUtil.Variable v = (IDUtil.Variable)o;
            if (v.getName().equals("sequence")) {
                int length = 0;
                if (v.getParams().size() > 0) {
                    try {
                        length = Integer.parseInt(v.getParams().get(0));
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                }
                if (length > s.length()) {
                    length = s.length();
                }
                for (int i = 0; i < length; ++i) {
                    if (Character.isDigit(s.charAt(i))) continue;
                    return null;
                }
                out.add(new IDUtil.VariableValue((IDUtil.Variable)o, s.substring(0, length)));
                s = s.substring(length, s.length());
                continue;
            }
            if (!v.getName().equals("id")) continue;
            if (lo == null) {
                out.add(new IDUtil.VariableValue((IDUtil.Variable)o, ""));
                continue;
            }
            if (!s.startsWith(lo.getID())) continue;
            s = s.substring(lo.getID().length(), s.length());
            out.add(new IDUtil.VariableValue((IDUtil.Variable)o, lo.getID()));
        }
        return out;
    }

    public DefaultIDGenerator() {
        this.defaultProfile.setDefaultRule("id:$sequence(7)$");
    }

    public void setProfile(IDProfile profile) {
        this.profile = profile;
    }

    public IDProfile getProfile() {
        if (this.profile == null) {
            return this.defaultProfile;
        }
        return this.profile;
    }

    public static String padNum(int val, int length) {
        StringBuffer out = new StringBuffer();
        out.append(val);
        for (int i = 1; i < length; ++i) {
            if ((int)Math.pow(10.0, i) <= val) continue;
            out.insert(0, "0");
        }
        return out.toString();
    }

    public static String resolveVar(IDUtil.Variable v, List valueList, LinkedObject lo) {
        if (v.getName().equals("sequence")) {
            int lowVal = 0;
            int highVal = Integer.MAX_VALUE;
            int padVal = 8;
            if (v.getParams().size() > 0) {
                try {
                    padVal = Integer.parseInt(v.getParams().get(0));
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            if (v.getParams().size() > 1) {
                try {
                    lowVal = Integer.parseInt(v.getParams().get(1));
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            if (v.getParams().size() > 2) {
                try {
                    highVal = Integer.parseInt(v.getParams().get(2));
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            int tentative = lowVal;
            for (Integer io : valueList) {
                int val = io;
                if (val < tentative) continue;
                if (val == tentative) {
                    ++tentative;
                    continue;
                }
                if (val <= tentative) continue;
                break;
            }
            if (tentative > highVal) {
                return null;
            }
            return DefaultIDGenerator.padNum(tentative, padVal);
        }
        if (v.getName().equals("id")) {
            if (lo == null) {
                return "";
            }
            return lo.getID();
        }
        return null;
    }

    public static Collection getIDs(OBOSession session) {
        HashSet<String> allReserved = new HashSet<String>();
        for (IdentifiableObject identifiableObject : session.getObjects()) {
            allReserved.add(identifiableObject.getID());
            if (!(identifiableObject instanceof MultiIDObject)) continue;
            for (String s : ((MultiIDObject)identifiableObject).getSecondaryIDs()) {
                allReserved.add(s);
            }
        }
        return allReserved;
    }

    public String generateID(OBOSession session, String currentRule, LinkedObject lo, Collection reservedIDs, boolean temporary) {
        Collection allReserved = DefaultIDGenerator.getIDs(session);
        if (reservedIDs != null) {
            allReserved.addAll(reservedIDs);
        }
        return this.generateID(currentRule, lo, allReserved, temporary);
    }

    public String generateID(String currentRule, LinkedObject lo, Collection reservedIDs, boolean temporary) {
        List list = IDUtil.parseVarString(currentRule);
        if (list == null) {
            return null;
        }
        LinkedList<List> matchList = new LinkedList<List>();
        if (reservedIDs != null) {
            for (String id : reservedIDs) {
                List seqMatch = DefaultIDGenerator.matchSequence(id, list, lo);
                if (seqMatch == null) continue;
                matchList.add(seqMatch);
            }
        }
        Iterator it = list.iterator();
        StringBuffer out = new StringBuffer();
        int varIndex = 0;
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof String) {
                out.append((String)o);
                continue;
            }
            if (!(o instanceof IDUtil.Variable)) continue;
            ArrayList<Integer> valueList = new ArrayList<Integer>();
            for (List varMatches : matchList) {
                IDUtil.VariableValue vv = (IDUtil.VariableValue)varMatches.get(varIndex);
                try {
                    valueList.add(new Integer(vv.getValue()));
                }
                catch (NumberFormatException ex) {}
            }
            Collections.sort(valueList);
            String varVal = DefaultIDGenerator.resolveVar((IDUtil.Variable)o, valueList, lo);
            if (varVal == null) {
                return null;
            }
            out.append(varVal);
            ++varIndex;
        }
        return out.toString();
    }

    @Override
    public String generateID(OBOSession session, LinkedObject lo, Collection reservedIDs, boolean temporary) {
        String currentRule = null;
        if (!temporary) {
            if (lo != null) {
                for (IDRule pair : this.profile.getRules()) {
                    if (!pair.getFilter().satisfies(lo)) continue;
                    currentRule = pair.getRule();
                    break;
                }
            }
            if (currentRule == null) {
                currentRule = this.profile.getDefaultRule();
            }
        } else {
            currentRule = "__temp__$sequence(10)$__";
        }
        return this.generateID(session, currentRule, lo, reservedIDs, temporary);
    }
}

