/*
 * Decompiled with CFR 0.152.
 */
package org.obo.nlp.test;

import java.util.Arrays;
import java.util.Collection;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.log4j.Logger;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.history.HistoryItem;
import org.obo.nlp.NamerUtil;
import org.obo.nlp.impl.LogicalDefinitionNamer;
import org.obo.nlp.test.AbstractNLPTest;

public class NameUnionsInOBITest
extends AbstractNLPTest {
    protected static final Logger logger = Logger.getLogger(NameUnionsInOBITest.class);

    public NameUnionsInOBITest(String name) {
        super(name);
    }

    @Override
    public Collection<String> getFilesToLoad() {
        String[] files = new String[]{"http://purl.org/obo/obo-all/obi/obi.obo"};
        return Arrays.asList(files);
    }

    public void testNaming() throws Exception {
        LogicalDefinitionNamer namer = new LogicalDefinitionNamer();
        String id = "obi:OBI_0100016";
        LinkedObject lo = (LinkedObject)this.session.getObject(id);
        boolean ok = false;
        Collection<String> names = namer.constructNames(lo);
        for (Link link : lo.getParents()) {
            LinkedObject po = link.getParent();
            if (po.getName() != null) continue;
            names.addAll(namer.constructNames(po));
            logger.info((Object)("names=" + names));
            for (String name : names) {
                logger.info((Object)("n=" + name));
                if (!name.contains("reagent") || !name.contains("specimen")) continue;
                ok = true;
            }
        }
        NameUnionsInOBITest.assertTrue((boolean)ok);
        NameUnionsInOBITest.assertTrue((names.size() == 1 ? 1 : 0) != 0);
        IdentifiedObject foo = this.session.getObject("obi:OBI_0000305");
        System.out.println(foo);
        System.out.println(foo.getName());
        NameUnionsInOBITest.assertTrue((boolean)foo.getName().equals("datum"));
        Collection<HistoryItem> items = NamerUtil.getNameUnnamedObjectsAction(this.session, namer);
        for (HistoryItem item : items) {
            System.out.println(item);
        }
    }

    public static void addTests(TestSuite suite) {
        suite.addTest((Test)new NameUnionsInOBITest("testLinks"));
    }
}

