/*
 * Decompiled with CFR 0.152.
 */
package org.obo.nlp.test;

import java.util.Arrays;
import java.util.Collection;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.log4j.Logger;
import org.obo.history.TermMacroHistoryItem;
import org.obo.nlp.impl.RegulationTermParser;
import org.obo.nlp.test.AbstractNLPTest;
import org.obo.reasoner.ReasonedLinkDatabase;
import org.obo.reasoner.impl.LinkPileReasonerFactory;

public class PositiveRegulationTermParserTest
extends AbstractNLPTest {
    protected static final Logger logger = Logger.getLogger(PositiveRegulationTermParserTest.class);

    public PositiveRegulationTermParserTest(String name) {
        super(name);
    }

    @Override
    public Collection<String> getFilesToLoad() {
        String[] files = new String[]{"positive_regulation.obo"};
        return Arrays.asList(files);
    }

    public void testLinks() throws Exception {
        this.semanticParser = new RegulationTermParser();
        this.semanticParser.index(this.session);
        Collection<TermMacroHistoryItem> items = this.semanticParser.parseTerms();
        for (TermMacroHistoryItem termMacroHistoryItem : items) {
            logger.info((Object)termMacroHistoryItem);
        }
        this.semanticParser.apply(items);
        int passes = 0;
        for (String report : this.semanticParser.getReports()) {
            logger.info((Object)report);
            if (report.contains("HIERARCHY: GO:0048518")) {
                ++passes;
            }
            if (report.contains("OK: GO:0046887")) {
                ++passes;
            }
            if (!report.contains("PREDEFINED: GO:0051046")) continue;
            ++passes;
        }
        PositiveRegulationTermParserTest.assertTrue((passes == 3 ? 1 : 0) != 0);
        String string = "GO:0048518";
        this.testForGenus(string, "GO:0065007");
        this.testForDifferentium(string, "positively_regulates", "GO:0008150");
        String string2 = "GO:0046887";
        this.testForGenus(string2, "GO:0065007");
        LinkPileReasonerFactory rf = new LinkPileReasonerFactory();
        ReasonedLinkDatabase reasoner = rf.createReasoner();
        reasoner.setLinkDatabase(this.session.getLinkDatabase());
        reasoner.recache();
        this.testForIsA(reasoner, string2, "GO:0046883");
        this.testForIsA(reasoner, string2, "GO:0048522");
        this.testForIsA(reasoner, string2, "GO:0051047");
    }

    public static void addTests(TestSuite suite) {
        suite.addTest((Test)new PositiveRegulationTermParserTest("testLinks"));
    }
}

