/*
 * Decompiled with CFR 0.152.
 */
package org.obo.nlp.test;

import java.util.Arrays;
import java.util.Collection;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.log4j.Logger;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOProperty;
import org.obo.history.TermMacroHistoryItem;
import org.obo.nlp.impl.RegulationTermParser;
import org.obo.nlp.test.AbstractNLPTest;
import org.obo.reasoner.ReasonedLinkDatabase;
import org.obo.reasoner.impl.LinkPileReasonerFactory;

public class RegulationOfSomitogenesisTest
extends AbstractNLPTest {
    protected static final Logger logger = Logger.getLogger(RegulationOfSomitogenesisTest.class);

    public RegulationOfSomitogenesisTest(String name) {
        super(name);
    }

    @Override
    public Collection<String> getFilesToLoad() {
        String[] files = new String[]{"regulation_of_somitogenesis.obo"};
        return Arrays.asList(files);
    }

    public void testLinks() throws Exception {
        this.semanticParser = new RegulationTermParser();
        this.semanticParser.index(this.session);
        Collection<TermMacroHistoryItem> items = this.semanticParser.parseTerms();
        for (TermMacroHistoryItem termMacroHistoryItem : items) {
            logger.info((Object)termMacroHistoryItem);
        }
        this.semanticParser.apply(items);
        int passes = 0;
        for (String string : this.semanticParser.getReports()) {
            logger.info((Object)string);
            if (string.contains("OK: regulation of transcription, DNA-dependent")) {
                ++passes;
            }
            if (!string.contains("OK: regulation of transcription, DNA-dependent")) continue;
            ++passes;
        }
        String string = "GO:0014807";
        this.testForGenus(string, "GO:0065007");
        this.testForDifferentium(string, "regulates", "GO:0001756");
        this.testForNoIsA(string, "GO:005079");
        for (Link link : ((LinkedObject)this.session.getObject("regulates")).getParents()) {
            logger.info((Object)(link + " " + link.getType().getID()));
        }
        logger.info((Object)("tOver=" + ((OBOProperty)this.session.getObject("regulates")).getTransitiveOver()));
        this.testForNonGenusIsA("GO:0050789", "GO:0065007");
        LinkPileReasonerFactory linkPileReasonerFactory = new LinkPileReasonerFactory();
        ReasonedLinkDatabase reasoner = linkPileReasonerFactory.createReasoner();
        reasoner.setLinkDatabase(this.session.getLinkDatabase());
        reasoner.recache();
        this.testForIsA(reasoner, string, "GO:0045995");
    }

    public static void addTests(TestSuite suite) {
        suite.addTest((Test)new RegulationOfSomitogenesisTest("testLinks"));
    }
}

