/*
 * Decompiled with CFR 0.152.
 */
package org.obo.owl.dataadapter;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.bbop.dataadapter.AdapterConfiguration;
import org.bbop.dataadapter.CancelledAdapterException;
import org.bbop.dataadapter.DataAdapter;
import org.bbop.dataadapter.DataAdapterException;
import org.bbop.dataadapter.DataAdapterUI;
import org.bbop.dataadapter.DataAdapterUIException;
import org.bbop.dataadapter.DefaultIOOperation;
import org.bbop.dataadapter.FileAdapterConfiguration;
import org.bbop.dataadapter.FileAdapterUI;
import org.bbop.dataadapter.GraphicalUI;
import org.bbop.dataadapter.IOOperation;
import org.bbop.io.IOUtil;
import org.bbop.util.AbstractProgressValued;
import org.obo.dataadapter.DefaultOBOParser;
import org.obo.dataadapter.OBOParseEngine;
import org.obo.dataadapter.OBOParseException;
import org.obo.dataadapter.OBOSerializationEngine;
import org.obo.dataadapter.OBOSerializer;
import org.obo.dataadapter.OBO_1_2_Serializer;
import org.obo.datamodel.OBOSession;
import org.obo.identifier.IDProfile;
import org.obolibrary.obo2owl.Obo2Owl;
import org.obolibrary.obo2owl.Owl2Obo;
import org.obolibrary.oboformat.model.OBODoc;
import org.obolibrary.oboformat.parser.OBOFormatParser;
import org.obolibrary.oboformat.parser.OBOFormatParserException;
import org.obolibrary.oboformat.writer.OBOFormatWriter;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;

public class OWLAdapter
extends AbstractProgressValued
implements DataAdapter {
    protected static final Logger logger = Logger.getLogger(OWLAdapter.class);
    private boolean cancelled = false;
    private OWLAdapterConfiguration ioprofile;
    private GraphicalUI advancedUI;
    protected String userName;
    protected String autogenString;
    protected IDProfile idProfile;
    public static final IOOperation<OBOSession, OBOSession> WRITE_ONTOLOGY = new DefaultIOOperation("WRITE_ONTOLOGY", "write ontology", OBOSession.class, OBOSession.class);
    public static final IOOperation<Void, OBOSession> READ_ONTOLOGY = new DefaultIOOperation("READ_ONTOLOGY", "read ontology", Void.class, OBOSession.class);

    public String getID() {
        return "OBO:OWLAdapter";
    }

    public String getName() {
        return "OBO OWL Adapter";
    }

    public IOOperation<?, ?>[] getSupportedOperations() {
        IOOperation[] supported = new IOOperation[]{READ_ONTOLOGY, WRITE_ONTOLOGY};
        return supported;
    }

    public DataAdapterUI getPreferredUI() {
        FileAdapterUI ui = new FileAdapterUI(){
            private static final long serialVersionUID = 8709597443707849569L;

            public AdapterConfiguration createEmptyConfig() {
                return new OWLAdapterConfiguration();
            }

            public void acceptComponentConfig(boolean storeonly) throws DataAdapterUIException {
                super.acceptComponentConfig(storeonly);
                OWLAdapterConfiguration config = (OWLAdapterConfiguration)this.config;
                config.setBasicSave(true);
            }

            protected String handleSelected(String selected, boolean write) {
                File file;
                String fileName;
                int i;
                selected = super.handleSelected(selected, write);
                if (write && (i = (fileName = (file = new File(selected)).getName()).lastIndexOf(46)) < 1) {
                    selected = selected + ".owl";
                }
                return selected;
            }
        };
        ui.setReadOperation(READ_ONTOLOGY);
        ui.setWriteOperation(WRITE_ONTOLOGY);
        GraphicalUI advancedUI = this.getAdvancedUI();
        if (advancedUI != null) {
            advancedUI.setSimpleUI((GraphicalUI)ui);
            ui.setAdvancedUI(advancedUI);
        }
        return ui;
    }

    public GraphicalUI getAdvancedUI() {
        return this.advancedUI;
    }

    public void setAdvancedUI(GraphicalUI advancedUI) {
        this.advancedUI = advancedUI;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public AdapterConfiguration getConfiguration() {
        return this.ioprofile;
    }

    public void setConfiguration(OWLAdapterConfiguration config) {
        this.ioprofile = config;
    }

    public <INPUT_TYPE, OUTPUT_TYPE> OUTPUT_TYPE doOperation(IOOperation<INPUT_TYPE, OUTPUT_TYPE> op, AdapterConfiguration configuration, INPUT_TYPE input) throws DataAdapterException {
        if (!(configuration instanceof OWLAdapterConfiguration)) {
            logger.info((Object)("conf=" + configuration.getClass()));
            throw new DataAdapterException(" - Invalid configuration; this adapter requires an OWLAdapterConfiguration object.");
        }
        this.cancelled = false;
        this.ioprofile = (OWLAdapterConfiguration)configuration;
        if (op.equals(READ_ONTOLOGY)) {
            OBOSession session = this.convertOWLOntologies(this.ioprofile.getReadPaths());
            return (OUTPUT_TYPE)session;
        }
        if (op.equals(WRITE_ONTOLOGY)) {
            this.convertToOWL((OBOSession)input);
            return (OUTPUT_TYPE)input;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OBOSession convertOWLOntologies(Collection<String> sources) throws DataAdapterException {
        ArrayList<String> tempOboFiles = new ArrayList<String>(sources.size());
        try {
            for (String f : sources) {
                String message;
                OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
                URI uri = f.indexOf(":") > 0 ? URI.create(f) : URI.create("file:" + f);
                logger.info((Object)("reading OWL ontology from URI " + uri));
                try {
                    OWLOntology ontology = manager.loadOntologyFromOntologyDocument(IRI.create((URI)uri));
                    this.checkCancelled();
                    Owl2Obo owl2Obo = new Owl2Obo();
                    owl2Obo.setStrictConversion(!this.ioprofile.isAllowLossy());
                    OBODoc oboDoc = owl2Obo.convert(ontology);
                    this.checkCancelled();
                    File tempFile = File.createTempFile("owl2obo", ".obo");
                    String tempFilePath = tempFile.getAbsolutePath();
                    tempOboFiles.add(tempFilePath);
                    OBOFormatWriter writer = new OBOFormatWriter();
                    writer.write(oboDoc, tempFilePath);
                    this.checkCancelled();
                }
                catch (OWLOntologyCreationException e) {
                    message = "Error reading OWL ontology from " + uri + ": " + e.getMessage();
                    logger.info((Object)message, (Throwable)e);
                    throw new DataAdapterException(message, (Throwable)e);
                }
                catch (IOException e) {
                    message = "Error converting OBO to OWL ontology from " + uri + ": " + e.getMessage();
                    logger.info((Object)message, (Throwable)e);
                    throw new DataAdapterException(message, (Throwable)e);
                }
            }
            OBOSession session = this.loadOBOSession(tempOboFiles);
            session.setLoadRemark(this.createLoadRemark(sources));
            session.setCurrentFilenames(sources);
            OBOSession oBOSession = session;
            return oBOSession;
        }
        finally {
            if (!tempOboFiles.isEmpty()) {
                for (String tempFile : tempOboFiles) {
                    this.deleteTempFile(new File(tempFile));
                }
            }
        }
    }

    private OBOSession loadOBOSession(List<String> paths) throws DataAdapterException {
        try {
            DefaultOBOParser parser = new DefaultOBOParser();
            parser.setAllowDanglingParents(this.ioprofile.getAllowDangling());
            parser.setFailFast(this.ioprofile.getFailFast());
            parser.setFollowImports(this.ioprofile.getFollowImports());
            OBOParseEngine engine = new OBOParseEngine(parser);
            engine.setPaths(paths);
            engine.parse();
            OBOSession session = parser.getSession();
            session.setLoadRemark(this.createLoadRemark(paths));
            return session;
        }
        catch (IOException e) {
            throw new DataAdapterException("Could not convert OWL ontology to OBO ", (Throwable)e);
        }
        catch (OBOParseException e) {
            throw new DataAdapterException("Could not load converted OBO file", (Throwable)e);
        }
    }

    private String createLoadRemark(String path) {
        return IOUtil.getShortName((String)path);
    }

    private String createLoadRemark(Collection<String> paths) {
        StringBuilder out = new StringBuilder();
        Iterator<String> it = paths.iterator();
        int i = 0;
        while (it.hasNext()) {
            String path = it.next();
            path = IOUtil.getShortName((String)path);
            if (i != 0) {
                out.append(", ");
            }
            out.append(path);
            ++i;
        }
        return out.toString();
    }

    private void convertToOWL(OBOSession session) throws DataAdapterException {
        OBOSerializationEngine.FilteredPath filteredPath;
        if (this.ioprofile.getBasicSave()) {
            filteredPath = new OBOSerializationEngine.FilteredPath(null, null, this.ioprofile.getWritePath());
            filteredPath.setAllowDangling(this.ioprofile.getAllowDangling());
        } else {
            List<OBOSerializationEngine.FilteredPath> saveRecords = this.ioprofile.getSaveRecords();
            if (saveRecords.isEmpty()) {
                filteredPath = new OBOSerializationEngine.FilteredPath(null, null, this.ioprofile.getWritePath());
                if (this.ioprofile.allowDangling) {
                    filteredPath.setAllowDangling(this.ioprofile.getAllowDangling());
                }
            } else if (saveRecords.size() == 1) {
                filteredPath = saveRecords.get(0);
            } else {
                throw new DataAdapterException("The OWL adapter does not support multiple filterPathes.");
            }
        }
        this.write(session, filteredPath);
    }

    private void write(OBOSession session, OBOSerializationEngine.FilteredPath filteredPath) throws DataAdapterException {
        File tempFile = null;
        try {
            tempFile = File.createTempFile("obo2owl", ".owl");
            this.checkCancelled();
            OBO_1_2_Serializer serializer = new OBO_1_2_Serializer();
            OBOSerializationEngine serializeEngine = new OBOSerializationEngine();
            serializeEngine.setUsername(this.getUserName());
            serializeEngine.setAutogenString(this.getAutogenString());
            serializeEngine.setCurrentProfile(this.getIDProfile());
            OBOSerializationEngine.FilteredPath tempPath = this.createTempFilteredPath(filteredPath, tempFile);
            serializeEngine.serialize(session, (OBOSerializer)serializer, Collections.singleton(tempPath));
            this.checkCancelled();
            OBOFormatParser parser = new OBOFormatParser();
            OBODoc oboDoc = parser.parse(tempFile);
            Obo2Owl obo2Owl = new Obo2Owl();
            OWLOntology owlOntology = obo2Owl.convert(oboDoc);
            this.checkCancelled();
            OWLOntologyManager manager = owlOntology.getOWLOntologyManager();
            manager.saveOntology(owlOntology, IRI.create((File)new File(filteredPath.getPath())));
            session.setCurrentFilenames(filteredPath.getPath());
            session.setLoadRemark(this.createLoadRemark(filteredPath.getPath()));
        }
        catch (IOException e) {
            throw new DataAdapterException("Could not create temp file for obo2owl conversion.", (Throwable)e);
        }
        catch (OWLOntologyCreationException e) {
            throw new DataAdapterException("Could not convert OBO to OWL.", (Throwable)e);
        }
        catch (OWLOntologyStorageException e) {
            throw new DataAdapterException("Could not save OWL to file: " + filteredPath.getPath(), (Throwable)e);
        }
        catch (OBOFormatParserException e) {
            throw new DataAdapterException("Could not parse OBO to file: " + filteredPath.getPath(), (Throwable)e);
        }
        finally {
            this.deleteTempFile(tempFile);
        }
    }

    private OBOSerializationEngine.FilteredPath createTempFilteredPath(OBOSerializationEngine.FilteredPath path, File tempFile) {
        OBOSerializationEngine.FilteredPath newPath = new OBOSerializationEngine.FilteredPath(path.getLinkFilter(), path.getObjectFilter(), path.getTagFilter(), tempFile.getAbsolutePath());
        newPath.setAllowDangling(path.getAllowDangling());
        newPath.setAssertImpliedLinks(path.getAllowDangling());
        newPath.setDiscardUnusedCategories(path.getDiscardUnusedCategories());
        newPath.setDoFilter(path.getDoFilter());
        newPath.setDoLinkFilter(path.getDoFilter());
        newPath.setDoTagFilter(path.getDoTagFilter());
        newPath.setIDRuleMode(path.getIDRuleMode());
        newPath.setImpliedType(path.getImpliedType());
        newPath.setIsaClosure(path.getIsaClosure());
        newPath.setPrefilterProperty(path.getPrefilterProperty());
        newPath.setReasonerFactory(path.getReasonerFactory());
        newPath.setRemark(path.getRemark());
        newPath.setRootAlgorithm(path.getRootAlgorithm());
        newPath.setSaveImplied(path.getSaveImplied());
        newPath.setSaveTypes(newPath.getSaveTypes());
        newPath.setTagsToWrite(path.getTagsToWrite());
        newPath.setUseSessionReasoner(path.getUseSessionReasoner());
        newPath.setWriteModificationData(path.getWriteModificationData());
        return newPath;
    }

    private void deleteTempFile(File file) {
        if (file != null) {
            try {
                file.delete();
            }
            catch (Exception e) {
                logger.warn((Object)("Could not delete temp file: " + file.getAbsolutePath()), (Throwable)e);
            }
        }
    }

    private void checkCancelled() throws CancelledAdapterException {
        if (this.cancelled) {
            throw new CancelledAdapterException();
        }
    }

    public String getUserName() {
        if (this.userName == null) {
            this.userName = System.getProperty("user.name");
        }
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getAutogenString() {
        return this.autogenString;
    }

    public void setAutogenString(String autogenString) {
        this.autogenString = autogenString;
    }

    public IDProfile getIDProfile() {
        return this.idProfile;
    }

    public void setIDProfile(IDProfile idProfile) {
        this.idProfile = idProfile;
    }

    public static class OWLAdapterConfiguration
    extends FileAdapterConfiguration {
        protected boolean allowDangling = false;
        protected boolean allowLossy = true;
        protected boolean followImports = true;
        protected boolean failFast = false;
        protected List<OBOSerializationEngine.FilteredPath> saveRecords = new ArrayList<OBOSerializationEngine.FilteredPath>();
        protected boolean basicSave = true;
        protected String impliedType = "Save for presentation";

        public boolean getBasicSave() {
            return this.basicSave;
        }

        public void setBasicSave(boolean basicSave) {
            this.basicSave = basicSave;
        }

        public List<OBOSerializationEngine.FilteredPath> getSaveRecords() {
            return this.saveRecords;
        }

        public void setSaveRecords(List<OBOSerializationEngine.FilteredPath> saveRecords) {
            if (saveRecords.contains(null)) {
                new Exception("Null save record added to profile").printStackTrace();
            }
            this.saveRecords = saveRecords;
        }

        public boolean getAllowDangling() {
            return this.allowDangling;
        }

        public void setAllowDangling(boolean allowDangling) {
            this.allowDangling = allowDangling;
        }

        public boolean isAllowLossy() {
            return this.allowLossy;
        }

        public void setAllowLossy(boolean allowLossy) {
            this.allowLossy = allowLossy;
        }

        public void setFailFast(boolean failFast) {
            this.failFast = failFast;
        }

        public boolean getFailFast() {
            return this.failFast;
        }

        public boolean getFollowImports() {
            return this.followImports;
        }

        public void setFollowImports(boolean followImports) {
            this.followImports = followImports;
        }
    }
}

