/*
 * Decompiled with CFR 0.152.
 */
package org.obo.query.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.bbop.util.TaskDelegate;
import org.obo.datamodel.LinkDatabase;
import org.obo.query.Query;
import org.obo.query.QueryResolver;

public abstract class CachingQueryResolver
implements QueryResolver {
    protected Map<Object, Map<Query, Collection>> results = new HashMap<Object, Map<Query, Collection>>();

    public void clearCache() {
        this.results = new HashMap<Object, Map<Query, Collection>>();
    }

    public <T, V> TaskDelegate<Collection<V>> query(LinkDatabase linkDatabase, Query<T, V> q, boolean cache) {
        Collection<V> c = this.fetchCachedQuery(linkDatabase, q);
        if (c == null) {
            TaskDelegate<Collection<V>> task = this.query(linkDatabase, q);
            if (cache) {
                TaskDelegateWrapper<V> taskWrapper = new TaskDelegateWrapper<V>(task, linkDatabase, q);
                return taskWrapper;
            }
            return task;
        }
        return new ResultsWrapper<V>(c);
    }

    protected void cacheResults(Object o, Query q, Collection c) {
        Map<Query, Collection> temp = this.results.get(o);
        if (temp == null) {
            temp = new HashMap<Query, Collection>();
            this.results.put(o, temp);
        }
        temp.put(q, c);
    }

    protected <V> Collection<V> fetchCachedQuery(Object o, Query q) {
        Collection c;
        Map<Query, Collection> temp = this.results.get(o);
        if (temp != null && (c = temp.get(q)) != null) {
            return c;
        }
        return null;
    }

    public <T, V> TaskDelegate<Collection<V>> query(Collection<T> objects, Query<T, V> q, boolean cache) {
        Collection<V> c = this.fetchCachedQuery(objects, q);
        if (c == null) {
            TaskDelegate<Collection<V>> task = this.query(objects, q);
            if (cache) {
                TaskDelegateWrapper<V> taskWrapper = new TaskDelegateWrapper<V>(task, objects, q);
                return taskWrapper;
            }
            return task;
        }
        return new ResultsWrapper<V>(c);
    }

    public <T, V> TaskDelegate<Collection<V>> subquery(Collection<V> objects, Query<T, V> q, boolean cache) {
        Collection<V> c = this.fetchCachedQuery(objects, q);
        if (c == null) {
            TaskDelegate<Collection<V>> task = this.subquery(objects, q);
            if (cache) {
                TaskDelegateWrapper<V> taskWrapper = new TaskDelegateWrapper<V>(task, objects, q);
                return taskWrapper;
            }
            return task;
        }
        return new ResultsWrapper<V>(c);
    }

    protected static class ResultsWrapper<V>
    implements TaskDelegate<Collection<V>> {
        protected Collection<V> results;

        public ResultsWrapper(Collection<V> results) {
            this.results = results;
        }

        public void cancel() {
        }

        public Collection<V> getResults() {
            return this.results;
        }

        public boolean isCancelled() {
            return false;
        }

        public boolean isRunning() {
            return false;
        }

        public void run() {
        }

        public String getProgressString() {
            return null;
        }

        public Number getProgressValue() {
            return null;
        }

        public Throwable getException() {
            return null;
        }

        public boolean isFailed() {
            return false;
        }
    }

    protected class TaskDelegateWrapper<V>
    implements TaskDelegate<Collection<V>> {
        TaskDelegate<Collection<V>> task;
        Object o;
        Query q;

        public TaskDelegateWrapper(TaskDelegate<Collection<V>> task, Object o, Query q) {
            this.task = task;
            this.o = o;
            this.q = q;
        }

        public void cancel() {
            this.task.cancel();
        }

        public Collection<V> getResults() {
            return (Collection)this.task.getResults();
        }

        public boolean isCancelled() {
            return this.task.isCancelled();
        }

        public boolean isRunning() {
            return this.task.isRunning();
        }

        public void run() {
            this.task.run();
            CachingQueryResolver.this.cacheResults(this.o, this.q, (Collection)this.task.getResults());
        }

        public String getProgressString() {
            return this.task.getProgressString();
        }

        public Number getProgressValue() {
            return this.task.getProgressValue();
        }

        public Throwable getException() {
            return this.task.getException();
        }

        public boolean isFailed() {
            return this.task.isFailed();
        }
    }
}

