/*
 * Decompiled with CFR 0.152.
 */
package org.obo.query.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import org.bbop.util.ObjectUtil;
import org.obo.datamodel.FieldPath;
import org.obo.datamodel.FieldPathSpec;
import org.obo.datamodel.OBOObject;
import org.obo.datamodel.TermSubset;
import org.obo.query.Query;
import org.obo.util.TermUtil;

public class CategoryObjQuery
implements Query<OBOObject, OBOObject> {
    protected Collection<String> categoryIDs = new HashSet<String>();
    protected Comparator<OBOObject> comparator = new Comparator<OBOObject>(){

        @Override
        public int compare(OBOObject o1, OBOObject o2) {
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    };

    public CategoryObjQuery(TermSubset ... categories) {
        for (TermSubset ns : categories) {
            this.categoryIDs.add(ns.getName());
        }
    }

    public CategoryObjQuery(String ... categoryNames) {
        for (String ns : categoryNames) {
            this.categoryIDs.add(ns);
        }
    }

    public CategoryObjQuery(Collection<String> categoryNames) {
        this.categoryIDs = categoryNames;
    }

    @Override
    public OBOObject convertToInputType(OBOObject original) {
        return original;
    }

    @Override
    public Collection<OBOObject> createResultHolder() {
        return new ArrayList<OBOObject>();
    }

    public void setComparator(Comparator<OBOObject> comparator) {
        this.comparator = comparator;
    }

    @Override
    public Comparator<OBOObject> getComparator() {
        return this.comparator;
    }

    @Override
    public Class<OBOObject> getInputType() {
        return OBOObject.class;
    }

    @Override
    public OBOObject matches(OBOObject a) {
        if (!a.isBuiltIn() && TermUtil.isClass(a)) {
            for (String catName : this.categoryIDs) {
                for (TermSubset cat : a.getSubsets()) {
                    if (!cat.getName().equals(catName)) continue;
                    return a;
                }
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        return o instanceof CategoryObjQuery && ObjectUtil.equals(((CategoryObjQuery)o).getCategoryNames(), this.categoryIDs);
    }

    public Collection<String> getCategoryNames() {
        return this.categoryIDs;
    }

    @Override
    public OBOObject convertToOutputType(OBOObject original) {
        return original;
    }

    @Override
    public Collection<FieldPathSpec> getInputPaths() {
        return null;
    }

    @Override
    public void setFieldPath(FieldPath path) {
    }
}

