/*
 * Decompiled with CFR 0.152.
 */
package org.obo.query.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.bbop.util.ObjectUtil;
import org.obo.datamodel.FieldPath;
import org.obo.datamodel.FieldPathSpec;
import org.obo.datamodel.OBOClass;
import org.obo.datamodel.TermSubset;
import org.obo.query.Query;
import org.obo.util.TermUtil;

public class CategoryQuery
implements Query<OBOClass, OBOClass> {
    protected static final Logger logger = Logger.getLogger(CategoryQuery.class);
    protected Collection<String> categoryIDs = new HashSet<String>();
    protected Comparator<OBOClass> comparator = new Comparator<OBOClass>(){

        @Override
        public int compare(OBOClass o1, OBOClass o2) {
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    };

    public CategoryQuery(TermSubset ... categories) {
        for (TermSubset ns : categories) {
            this.categoryIDs.add(ns.getName());
        }
    }

    public CategoryQuery(String ... categoryNames) {
        for (String ns : categoryNames) {
            this.categoryIDs.add(ns);
        }
    }

    public CategoryQuery(Collection<String> categoryNames) {
        this.categoryIDs = categoryNames;
    }

    @Override
    public OBOClass convertToInputType(OBOClass original) {
        return original;
    }

    @Override
    public Collection<OBOClass> createResultHolder() {
        return new ArrayList<OBOClass>();
    }

    public void setComparator(Comparator<OBOClass> comparator) {
        this.comparator = comparator;
    }

    @Override
    public Comparator<OBOClass> getComparator() {
        return this.comparator;
    }

    @Override
    public Class<OBOClass> getInputType() {
        return OBOClass.class;
    }

    @Override
    public OBOClass matches(OBOClass a) {
        if (!a.isBuiltIn() && TermUtil.isClass(a)) {
            for (String catName : this.categoryIDs) {
                for (TermSubset cat : a.getSubsets()) {
                    if (!cat.getName().equals(catName)) continue;
                    return a;
                }
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        return o instanceof CategoryQuery && ObjectUtil.equals(((CategoryQuery)o).getCategoryNames(), this.categoryIDs);
    }

    public Collection<String> getCategoryNames() {
        return this.categoryIDs;
    }

    @Override
    public OBOClass convertToOutputType(OBOClass original) {
        return original;
    }

    @Override
    public Collection<FieldPathSpec> getInputPaths() {
        return null;
    }

    @Override
    public void setFieldPath(FieldPath path) {
    }
}

