/*
 * Decompiled with CFR 0.152.
 */
package org.obo.query.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.apache.log4j.Logger;
import org.obo.datamodel.FieldPath;
import org.obo.datamodel.FieldPathSpec;
import org.obo.filters.Filter;
import org.obo.filters.ParentSearchCriterion;
import org.obo.filters.SearchCriterion;
import org.obo.query.Query;
import org.obo.query.impl.BasicSearchHit;
import org.obo.query.impl.SearchHit;
import org.obo.reasoner.ReasonedLinkDatabase;

public class FilterQuery<T>
implements Query<T, SearchHit<T>> {
    protected static final Logger logger = Logger.getLogger(FilterQuery.class);
    protected Filter<T> filter;
    protected Class<T> inputType;
    protected static Collection<FieldPathSpec> inputPaths = new ArrayList<FieldPathSpec>();
    protected ReasonedLinkDatabase reasoner;

    public FilterQuery(Filter<T> filter, Class<T> inputType, ReasonedLinkDatabase reasoner) {
        this.filter = filter;
        this.inputType = inputType;
        this.setReasoner(reasoner);
    }

    @Override
    public T convertToInputType(SearchHit<T> original) {
        return original.getHit();
    }

    @Override
    public SearchHit<T> convertToOutputType(T original) {
        return new BasicSearchHit<T>(original);
    }

    @Override
    public Collection<SearchHit<T>> createResultHolder() {
        return null;
    }

    @Override
    public Comparator<? super SearchHit<T>> getComparator() {
        return null;
    }

    @Override
    public Class<T> getInputType() {
        return this.inputType;
    }

    @Override
    public SearchHit<T> matches(T a) {
        this.filter.setReasoner(this.reasoner);
        if (this.filter.satisfies(a)) {
            return new BasicSearchHit<T>(a);
        }
        return null;
    }

    @Override
    public Collection<FieldPathSpec> getInputPaths() {
        return inputPaths;
    }

    @Override
    public void setFieldPath(FieldPath path) {
    }

    public ReasonedLinkDatabase getReasoner() {
        return this.reasoner;
    }

    public void setReasoner(ReasonedLinkDatabase reasoner) {
        this.reasoner = reasoner;
        this.filter.setReasoner(reasoner);
    }

    public String toString() {
        return this.filter.toString();
    }

    static {
        inputPaths.add(new FieldPathSpec(new SearchCriterion[0]));
        inputPaths.add(new FieldPathSpec(new ParentSearchCriterion()));
    }
}

