/*
 * Decompiled with CFR 0.152.
 */
package org.obo.query.impl;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.obo.datamodel.IdentifiedObject;
import org.obo.filters.SearchCriterion;
import org.obo.query.impl.ScoredStringHit;

public class ScoredCriterionHit {
    protected static final Logger logger = Logger.getLogger(ScoredCriterionHit.class);
    protected SearchCriterion<IdentifiedObject, String> criterion;
    protected List<ScoredStringHit> hits = new LinkedList<ScoredStringHit>();
    double weight = 0.0;
    protected String searchString;
    public static final Comparator<ScoredCriterionHit> WEIGHT_COMPARATOR = new Comparator<ScoredCriterionHit>(){

        @Override
        public int compare(ScoredCriterionHit o1, ScoredCriterionHit o2) {
            return (int)(o2.getWeight() - o1.getWeight());
        }
    };

    public ScoredCriterionHit(SearchCriterion<IdentifiedObject, String> criterion, double weight, String searchString) {
        this.criterion = criterion;
        this.weight = weight;
        this.searchString = searchString;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public Map<String, Collection<ScoredStringHit>> getHitMap() {
        HashMap<String, Collection<ScoredStringHit>> out = new HashMap<String, Collection<ScoredStringHit>>();
        for (ScoredStringHit hit : this.hits) {
            LinkedList<ScoredStringHit> hitCollection = (LinkedList<ScoredStringHit>)out.get(hit.getMatchString());
            if (hitCollection == null) {
                hitCollection = new LinkedList<ScoredStringHit>();
                out.put(hit.getMatchString(), hitCollection);
            }
            hitCollection.add(hit);
        }
        return out;
    }

    public void addStringHit(ScoredStringHit scoredStringHit) {
        this.hits.add(scoredStringHit);
    }

    public Collection<ScoredStringHit> getHits() {
        return this.hits;
    }

    public double getScore() {
        double score = 0.0;
        double inOrderMultiplier = 1.0;
        ScoredStringHit lastHit = null;
        for (ScoredStringHit hit : this.hits) {
            if (lastHit != null) {
                inOrderMultiplier = lastHit.getHitPos() > hit.getHitPos() ? 1.0 : (inOrderMultiplier += 1.0);
            }
            score += hit.getScore();
            lastHit = hit;
        }
        return this.weight * score * inOrderMultiplier;
    }

    public SearchCriterion<IdentifiedObject, String> getCriterion() {
        return this.criterion;
    }

    public double getWeight() {
        return this.weight;
    }
}

