/*
 * Decompiled with CFR 0.152.
 */
package org.obo.query.impl;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.obo.datamodel.FieldPath;
import org.obo.filters.SearchCriterion;
import org.obo.query.impl.BasicSearchHit;
import org.obo.query.impl.ScoredCriterionHit;

public class ScoredPathHit
extends BasicSearchHit<FieldPath> {
    protected static final Logger logger = Logger.getLogger(ScoredPathHit.class);
    protected FieldPath object;
    protected Collection<ScoredCriterionHit> criterionHits;
    public static final Comparator<ScoredPathHit> COMPARATOR = new Comparator<ScoredPathHit>(){

        @Override
        public int compare(ScoredPathHit o1, ScoredPathHit o2) {
            int val = (int)(o2.getScore() - o1.getScore());
            if (val == 0) {
                return o1.getString().compareToIgnoreCase(o2.getString());
            }
            return val;
        }
    };

    public ScoredPathHit(FieldPath object) {
        super(object);
    }

    public String getString() {
        return this.object.getLastValue().toString();
    }

    public Collection<ScoredCriterionHit> getHitsForCriterion(SearchCriterion crit) {
        return this.getHitsForCriterion(crit.getID());
    }

    public Collection<ScoredCriterionHit> getHitsForCriterion(String critID) {
        LinkedList<ScoredCriterionHit> out = new LinkedList<ScoredCriterionHit>();
        for (ScoredCriterionHit hit : this.criterionHits) {
            if (!hit.getCriterion().getID().equals(critID)) continue;
            out.add(hit);
        }
        return out;
    }

    public void addCriterionHit(ScoredCriterionHit hit) {
        if (this.criterionHits == null) {
            this.criterionHits = new LinkedList<ScoredCriterionHit>();
        }
        this.criterionHits.add(hit);
    }

    public double getScore() {
        double score = 0.0;
        for (ScoredCriterionHit hit : this.criterionHits) {
            score += hit.getScore();
        }
        return score;
    }

    public Collection<ScoredCriterionHit> getCriterionHits() {
        return this.criterionHits;
    }
}

