/*
 * Decompiled with CFR 0.152.
 */
package org.obo.reasoner;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.obo.reasoner.ReasonerFactory;
import org.obo.reasoner.rbr.RuleBasedReasonerFactory;

public class ReasonerRegistry {
    protected static final Logger logger = Logger.getLogger(ReasonerRegistry.class);
    private static ReasonerRegistry instance;
    private Map<String, ReasonerFactory> factoryMap = new HashMap<String, ReasonerFactory>();
    private ReasonerFactory defaultReasonerFactory = new RuleBasedReasonerFactory();
    private String defaultReasonerName = "RuleBasedReasoner";

    private ReasonerRegistry() {
        this.registerReasoner("RuleBasedReasoner", new RuleBasedReasonerFactory());
    }

    public static synchronized ReasonerRegistry getInstance() {
        if (instance == null) {
            instance = new ReasonerRegistry();
        }
        return instance;
    }

    public void clearFactoryMap() {
        this.factoryMap.clear();
    }

    public Collection<String> getRegisteredNames() {
        return this.factoryMap.keySet();
    }

    public Collection<ReasonerFactory> getRegisteredFactories() {
        return this.factoryMap.values();
    }

    public ReasonerFactory lookupFactory(String name) {
        return this.factoryMap.get(name);
    }

    public void registerReasoner(String name, ReasonerFactory factory) {
        this.factoryMap.put(name, factory);
    }

    public void unregisterMapping(String name) {
        this.factoryMap.remove(name);
    }

    public ReasonerFactory getDefaultReasonerFactory() {
        return this.defaultReasonerFactory;
    }

    public String getDefaultReasonerName() {
        return this.defaultReasonerName;
    }
}

