/*
 * Decompiled with CFR 0.152.
 */
package org.obo.reasoner.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.log4j.Logger;
import org.bbop.util.MultiHashMap;
import org.bbop.util.MultiHashSetMap;
import org.bbop.util.MultiMap;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Instance;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkDatabase;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.MutableLinkDatabase;
import org.obo.datamodel.OBOClass;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.PathCapable;
import org.obo.datamodel.impl.AbstractLinkDatabase;
import org.obo.datamodel.impl.DefaultMutableLinkDatabase;
import org.obo.reasoner.Explanation;
import org.obo.reasoner.ExplanationType;
import org.obo.reasoner.ReasonedLinkDatabase;
import org.obo.reasoner.ReasonerListener;
import org.obo.reasoner.impl.GivenExplanation;
import org.obo.util.ReasonerUtil;
import org.obo.util.TermUtil;

public abstract class AbstractReasoner
extends AbstractLinkDatabase
implements ReasonedLinkDatabase {
    protected static final Logger logger = Logger.getLogger(AbstractReasoner.class);
    protected MultiMap<Link, Explanation> explanationMap;
    protected MultiMap<Link, Explanation> explanationDeps;
    protected LinkDatabase linkDatabase;
    protected MutableLinkDatabase impliedLinkDatabase;
    protected boolean cancelled = false;
    protected boolean running = false;
    protected boolean storeGivenLinks = false;
    protected String progressString;
    protected Number progressValue;
    protected long expTime = 0L;
    protected Collection<ReasonerListener> reasonerListeners = new LinkedList<ReasonerListener>();
    protected Collection links;
    protected Collection<OBOProperty> properties;

    @Override
    public Collection<OBOProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(Collection<OBOProperty> properties) {
        this.properties = properties;
    }

    public void setStoreGivenLinks(boolean storeGivenLinks) {
        this.storeGivenLinks = storeGivenLinks;
    }

    protected abstract void doReasoning();

    protected abstract void doAddLink(Link var1);

    protected abstract void doAddLinks(Collection<Link> var1);

    protected MutableLinkDatabase createImpliedLinkDatabase(LinkDatabase linkDatabase) {
        DefaultMutableLinkDatabase mldb = new DefaultMutableLinkDatabase(true);
        mldb.setProperties(linkDatabase.getProperties());
        return mldb;
    }

    public void cancel() {
        this.cancelled = true;
    }

    @Override
    public Collection<Explanation> getExplanations(PathCapable link) {
        Collection exps = (Collection)this.explanationMap.get((Object)link);
        if (exps.size() == 0 && !this.storeGivenLinks && link instanceof Link) {
            return Collections.singleton(new GivenExplanation((Link)link));
        }
        return exps;
    }

    @Override
    public LinkDatabase getLinkDatabase() {
        return this.linkDatabase;
    }

    public Set<LinkedObject> getParentsOfType(LinkedObject a, OBOProperty b) {
        LinkedHashSet<LinkedObject> out = new LinkedHashSet<LinkedObject>();
        for (Link link : this.getParents(a)) {
            if (!this.isSubPropertyOf(link.getType(), b)) continue;
            out.add(link.getParent());
        }
        return out;
    }

    @Override
    public Link hasRelationship(LinkedObject a, OBOProperty b, LinkedObject c) {
        for (Link link : this.getParents(a)) {
            if (TermUtil.isIntersection(link) || !this.isSubPropertyOf(link.getType(), b) || !link.getParent().equals(c)) continue;
            return link;
        }
        return null;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public boolean isSubPropertyOf(OBOProperty a, OBOProperty b) {
        return this.isSubclass(a, b);
    }

    @Override
    public boolean isSubclassOf(OBOClass a, OBOClass b) {
        return this.isSubclass(a, b);
    }

    public boolean isSubclass(LinkedObject a, LinkedObject b) {
        if (a.equals(b)) {
            return true;
        }
        for (Link link : this.getParents(a)) {
            if (!this.isSubPropertyOf(link.getType(), OBOProperty.IS_A) || !link.getParent().equals(b)) continue;
            return true;
        }
        return false;
    }

    protected void fireDone() {
        for (ReasonerListener reasonerListener : this.reasonerListeners) {
            reasonerListener.reasoningFinished();
        }
    }

    protected void fireStart() {
        for (ReasonerListener reasonerListener : this.reasonerListeners) {
            reasonerListener.reasoningStarted();
        }
    }

    protected void fireCancelled() {
        for (ReasonerListener reasonerListener : this.reasonerListeners) {
            reasonerListener.reasoningCancelled();
        }
    }

    @Override
    public void addReasonerListener(ReasonerListener listener) {
        this.reasonerListeners.add(listener);
    }

    @Override
    public void removeReasonerListener(ReasonerListener listener) {
        this.reasonerListeners.remove(listener);
    }

    @Override
    public void setLinkDatabase(LinkDatabase linkDatabase) {
        this.linkDatabase = linkDatabase;
        this.setProperties(linkDatabase.getProperties());
    }

    @Override
    public Collection<IdentifiedObject> getObjects() {
        return this.linkDatabase.getObjects();
    }

    @Override
    public Collection<Link> getChildren(LinkedObject lo) {
        if (!this.storeGivenLinks) {
            Collection<Link> given = this.linkDatabase.getChildren(lo);
            Collection<Link> impliedChildren = this.impliedLinkDatabase.getChildren(lo);
            LinkedHashSet<Link> out = new LinkedHashSet<Link>(given.size() + impliedChildren.size());
            out.addAll(given);
            out.addAll(impliedChildren);
            return out;
        }
        return this.impliedLinkDatabase.getChildren(lo);
    }

    @Override
    public Collection<Link> getParents(LinkedObject lo) {
        if (!this.storeGivenLinks) {
            Collection<Link> given = this.linkDatabase.getParents(lo);
            Collection<Link> impliedParents = this.impliedLinkDatabase.getParents(lo);
            LinkedHashSet<Link> out = new LinkedHashSet<Link>(given.size() + impliedParents.size());
            out.addAll(given);
            out.addAll(impliedParents);
            return out;
        }
        return this.impliedLinkDatabase.getParents(lo);
    }

    @Override
    public IdentifiedObject getObject(String id) {
        return this.linkDatabase.getObject(id);
    }

    @Override
    public boolean isInstanceOf(Instance a, OBOClass b) {
        return this.isSubclassOf((OBOClass)a.getType(), b);
    }

    @Override
    public boolean isRedundant(Link link) {
        return ReasonerUtil.isRedundant(this, link);
    }

    protected void initReasoner() {
        this.running = true;
        this.fireStart();
        this.impliedLinkDatabase = this.createImpliedLinkDatabase(this.getLinkDatabase());
        this.explanationMap = new MultiHashSetMap();
        this.explanationDeps = new MultiHashSetMap();
    }

    protected void cleanupReasoner() {
        this.fireDone();
        this.running = false;
    }

    @Override
    public void addLinks(Collection<Link> links) {
        this.running = true;
        this.doAddLinks(links);
        this.running = false;
    }

    @Override
    public void addLink(Link link) {
        this.running = true;
        this.doAddLink(link);
        this.running = false;
    }

    @Override
    public void removeLink(Link link) {
        this.running = true;
        this.doRemoveLink(link);
        this.running = false;
    }

    protected void doRemoveLink(Link link) {
        this.reasonRemoval(link);
    }

    protected void reasonRemoval(Link link) {
        this.impliedLinkDatabase.removeParent(link);
        this.explanationMap.remove((Object)link);
        Collection deps = (Collection)this.explanationDeps.get((Object)link);
        if (deps == null) {
            return;
        }
        for (Explanation exp : deps) {
            boolean dead = exp.removeEvidence(link);
            if (!dead) continue;
            for (Link ev : exp.getEvidence()) {
                Collection exps = (Collection)this.explanationDeps.get((Object)ev);
                if (exps == null) continue;
                exps.remove(exp);
                if (exps.size() != 0) continue;
                this.explanationDeps.remove((Object)ev);
            }
            PathCapable explainedObject = exp.getExplainedObject();
            Collection<Explanation> exps = this.getExplanations(explainedObject);
            exps.remove(exp);
            if (exps.size() != 0) continue;
            this.reasonRemoval(exp.getExplainedObject());
        }
    }

    protected void reasonRemoval(PathCapable pc) {
        if (pc instanceof Link) {
            this.reasonRemoval((Link)pc);
        }
    }

    protected static boolean isGiven(Explanation exp) {
        return exp.getExplanationType().equals((Object)ExplanationType.GIVEN);
    }

    protected void explain(Link link, Explanation explanation) {
        if (this.storeGivenLinks || !AbstractReasoner.isGiven(explanation)) {
            this.internalAddLink(link);
            this.internalAddExplanation(link, explanation);
        }
    }

    protected void internalAddExplanation(Link link, Explanation explanation) {
        long time = System.nanoTime();
        this.explanationMap.add((Object)link, (Object)explanation);
        for (Link evidence : explanation.getEvidence()) {
            this.explanationDeps.add((Object)evidence, (Object)explanation);
        }
        this.expTime += System.nanoTime() - time;
    }

    protected void internalAddLink(Link link) {
        this.impliedLinkDatabase.addParent(link);
    }

    @Override
    public long recache() {
        long time = System.currentTimeMillis();
        this.initReasoner();
        this.doReasoning();
        this.cleanupReasoner();
        return System.currentTimeMillis() - time;
    }

    public static MultiMap<Link, Explanation> createDepMap(MultiMap<Link, Explanation> expMap) {
        MultiHashMap out = new MultiHashMap();
        for (Explanation exp : expMap.singleValues()) {
            for (Link evidence : exp.getEvidence()) {
                out.add((Object)evidence, (Object)exp);
            }
        }
        return out;
    }

    public String getProgressString() {
        return this.progressString;
    }

    protected void setProgressString(String progressString) {
        this.progressString = progressString;
    }

    protected void setProgressValue(Number progressValue) {
        this.progressValue = progressValue;
    }

    public Number getProgressValue() {
        return this.progressValue;
    }
}

