/*
 * Decompiled with CFR 0.152.
 */
package org.obo.reasoner.impl;

import java.util.Collection;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOProperty;
import org.obo.reasoner.Explanation;
import org.obo.reasoner.ReasonedLinkDatabase;
import org.obo.reasoner.impl.LinkPileReasoner;
import org.obo.reasoner.impl.ReasonerRule;
import org.obo.util.TermUtil;

public abstract class AbstractReasonerRule
implements ReasonerRule {
    public long ruleTime;
    protected boolean allowIntersections = false;

    public void setAllowIntersections(boolean allowIntersections) {
        this.allowIntersections = allowIntersections;
    }

    @Override
    public void end(ReasonedLinkDatabase reasoner) {
    }

    @Override
    public void init(ReasonedLinkDatabase reasoner) {
        this.ruleTime = 0L;
    }

    @Override
    public void install(ReasonedLinkDatabase reasoner) {
    }

    @Override
    public void uninstall(ReasonedLinkDatabase reasoner) {
    }

    protected abstract Collection<Explanation> doGetImplications(ReasonedLinkDatabase var1, Link var2);

    @Override
    public Collection<Explanation> getImplications(ReasonedLinkDatabase reasoner, Link newLink) {
        if (!this.allowIntersections && TermUtil.isIntersection(newLink)) {
            return null;
        }
        long time = System.nanoTime();
        Collection<Explanation> out = this.doGetImplications(reasoner, newLink);
        this.ruleTime += System.nanoTime() - time;
        return out;
    }

    protected Link createLink(LinkedObject child, OBOProperty type, LinkedObject parent) {
        return new LinkPileReasoner.ReasonerLink(child, type, parent);
    }
}

