/*
 * Decompiled with CFR 0.152.
 */
package org.obo.reasoner.impl;

import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.bbop.dataadapter.DataAdapterException;
import org.bbop.util.ProgressValued;
import org.bbop.util.TinySet;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Instance;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkDatabase;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.MutableLinkDatabase;
import org.obo.datamodel.OBOClass;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.OBORestriction;
import org.obo.datamodel.OBOSession;
import org.obo.datamodel.PathCapable;
import org.obo.datamodel.Relationship;
import org.obo.datamodel.impl.AbstractLinkDatabase;
import org.obo.datamodel.impl.DefaultMutableLinkDatabase;
import org.obo.datamodel.impl.OBORestrictionImpl;
import org.obo.reasoner.Explanation;
import org.obo.reasoner.ExplanationType;
import org.obo.reasoner.ReasonedLinkDatabase;
import org.obo.reasoner.ReasonerListener;
import org.obo.reasoner.impl.AbstractExplanation;
import org.obo.reasoner.impl.AlwaysImpliesInverseExplanation;
import org.obo.reasoner.impl.CompletenessExplanation;
import org.obo.reasoner.impl.CompletenessMatch;
import org.obo.reasoner.impl.DifferentiaExplanation;
import org.obo.reasoner.impl.ExternallyImpliedExplanation;
import org.obo.reasoner.impl.GenusExplanation;
import org.obo.reasoner.impl.GivenExplanation;
import org.obo.reasoner.impl.SymmetryExplanation;
import org.obo.reasoner.impl.TransitivityExplanation;
import org.obo.util.ReasonerUtil;
import org.obo.util.TermUtil;

public class ForwardChainingReasoner
extends AbstractLinkDatabase
implements ReasonedLinkDatabase,
ProgressValued {
    protected static final Logger logger = Logger.getLogger(ForwardChainingReasoner.class);
    private static final long serialVersionUID = -5046369728943561325L;
    protected LinkDatabase linkDatabase;
    protected MutableLinkDatabase impliedLinkDatabase;
    protected Map<LinkedObject, Collection<Link>> intersectionMap = new LinkedHashMap<LinkedObject, Collection<Link>>();
    protected Map<Link, Collection<Explanation>> explanationMap = new HashMap<Link, Collection<Explanation>>();
    protected Map<Link, Collection<Explanation>> explanationDeps = new HashMap<Link, Collection<Explanation>>();
    protected Number progressVal;
    protected String progressString;
    protected boolean useTinySet = false;
    protected boolean evidenceLinkedListMode = true;
    protected boolean neverFindMode = true;
    protected boolean cancelled = false;
    protected boolean isRunning = false;
    protected OBORestriction lookupLink = new OBORestrictionImpl();
    int findAttempts = 0;
    int findHits = 0;
    boolean debugMode = false;
    protected int newLinks = 0;
    protected boolean recaching = false;
    protected Set<String> trash;
    protected OBORestriction tempLink = new OBORestrictionImpl((LinkedObject)null, null, (LinkedObject)null);
    long reasonLinkTime = 0L;
    public long explainTime = 0L;
    long addLinkTime = 0L;
    long existsTime = 0L;
    long findLinkTime = 0L;
    long expMapSetupTime = 0L;
    long depExpMapSetupTime = 0L;
    protected Collection<ReasonerListener> reasonerListeners = new LinkedList<ReasonerListener>();
    public static boolean checkRecache = false;
    public static Link weirdLink;

    public ForwardChainingReasoner(MutableLinkDatabase impliedLinkDatabase) {
        this.setImpliedLinkDatabase(impliedLinkDatabase);
    }

    protected void setImpliedLinkDatabase(MutableLinkDatabase impliedLinkDatabase) {
        this.impliedLinkDatabase = impliedLinkDatabase;
    }

    public Map<Link, Collection<Explanation>> getExplanationMap() {
        return this.explanationMap;
    }

    public Map<Link, Collection<Explanation>> getExplanationDepsMap() {
        return this.explanationDeps;
    }

    public ForwardChainingReasoner() {
        this(ForwardChainingReasoner.createImpliedLinkDatabase(null));
    }

    protected Map<LinkedObject, Collection<Link>> getIntersectionMap() {
        return this.intersectionMap;
    }

    protected void clearIntersectionMap() {
        this.intersectionMap.clear();
    }

    protected static MutableLinkDatabase createImpliedLinkDatabase(LinkDatabase linkDatabase) {
        return new DefaultMutableLinkDatabase(true);
    }

    public void addActionListener(ActionListener listener) {
    }

    public void removeActionListener(ActionListener listener) {
    }

    protected Link findLink(LinkedObject child, OBOProperty type, LinkedObject parent) {
        return this.findLink(child, type, parent, false);
    }

    protected Link findLink(LinkedObject child, OBOProperty type, LinkedObject parent, boolean completes) {
        ++this.findAttempts;
        long time = System.currentTimeMillis();
        for (Link link : this.getParents(child)) {
            if (!this.isSubPropertyOf(link.getType(), type) || !link.getParent().equals(parent) || TermUtil.isIntersection(link) != completes) continue;
            this.findLinkTime += System.currentTimeMillis() - time;
            ++this.findHits;
            return link;
        }
        this.findLinkTime += System.currentTimeMillis() - time;
        return null;
    }

    protected boolean linkExists(Link link) {
        long time = System.currentTimeMillis();
        Collection<Link> parents = this.getParents(link.getChild());
        this.existsTime += System.currentTimeMillis() - time;
        return parents.contains(link);
    }

    protected Link findOrCreateLink(LinkedObject child, OBOProperty type, LinkedObject parent) {
        if (this.neverFindMode) {
            return new OBORestrictionImpl(child, type, parent, true);
        }
        Link out = this.findLink(child, type, parent);
        if (out == null) {
            out = new OBORestrictionImpl(child, type, parent, true);
        }
        return out;
    }

    protected void internalAddLink(Link link) {
        if (link.getParent().equals(link.getChild())) {
            logger.info((Object)"Created new cycle!");
        }
        long time = System.currentTimeMillis();
        ++this.newLinks;
        if (TermUtil.isIntersection(link)) {
            Collection<Link> completeParents = this.intersectionMap.get(link.getChild());
            if (completeParents == null) {
                completeParents = new LinkedHashSet<Link>();
                this.intersectionMap.put(link.getChild(), completeParents);
            }
            completeParents.add(link);
            this.doGenusDifferentiaImplications(link);
        } else {
            this.impliedLinkDatabase.addParent(link);
        }
        this.addLinkTime += System.currentTimeMillis() - time;
    }

    @Override
    public void setLinkDatabase(LinkDatabase linkDatabase) {
        this.linkDatabase = linkDatabase;
        this.setImpliedLinkDatabase(ForwardChainingReasoner.createImpliedLinkDatabase(linkDatabase));
    }

    @Override
    public LinkDatabase getLinkDatabase() {
        return this.linkDatabase;
    }

    @Override
    public Collection<IdentifiedObject> getObjects() {
        return this.linkDatabase.getObjects();
    }

    @Override
    public Collection<Link> getChildren(LinkedObject lo) {
        Collection<Link> given = this.linkDatabase.getChildren(lo);
        Collection<Link> impliedChildren = this.impliedLinkDatabase.getChildren(lo);
        LinkedHashSet<Link> out = new LinkedHashSet<Link>(given.size() + impliedChildren.size());
        out.addAll(impliedChildren);
        out.addAll(given);
        return out;
    }

    @Override
    public Collection<Link> getParents(LinkedObject lo) {
        Collection<Link> given = this.linkDatabase.getParents(lo);
        Collection<Link> impliedParents = this.impliedLinkDatabase.getParents(lo);
        LinkedHashSet<Link> out = new LinkedHashSet<Link>(given.size() + impliedParents.size());
        out.addAll(impliedParents);
        out.addAll(given);
        return out;
    }

    public boolean isSubclass(LinkedObject a, LinkedObject b) {
        if (a.equals(b)) {
            return true;
        }
        for (Link link : this.getParents(a)) {
            if (!this.isSubPropertyOf(link.getType(), OBOProperty.IS_A) || !link.getParent().equals(b)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Link hasRelationship(LinkedObject a, OBOProperty b, LinkedObject c) {
        for (Link link : this.getParents(a)) {
            if (!this.isSubPropertyOf(link.getType(), b) || !link.getParent().equals(c)) continue;
            return link;
        }
        return null;
    }

    public Set<LinkedObject> getParentsOfType(LinkedObject a, OBOProperty b) {
        Set<LinkedObject> out = this.createSet();
        for (Link link : this.getParents(a)) {
            if (!this.isSubPropertyOf(link.getType(), b)) continue;
            out.add(link.getParent());
        }
        return out;
    }

    @Override
    public boolean isInstanceOf(Instance a, OBOClass b) {
        return false;
    }

    @Override
    public boolean isSubPropertyOf(OBOProperty a, OBOProperty b) {
        return this.isSubclass(a, b);
    }

    @Override
    public boolean isSubclassOf(OBOClass a, OBOClass b) {
        return this.isSubclass(a, b);
    }

    @Override
    public boolean isRedundant(Link link) {
        return ReasonerUtil.isRedundant(this, link);
    }

    @Override
    public void addLinks(Collection<Link> links) {
        for (Link link : links) {
            if (link instanceof OBORestriction && ((OBORestriction)link).getCompletes()) {
                LinkedList<CompletenessExplanation> completeExplanations = new LinkedList<CompletenessExplanation>();
                for (Link link2 : this.getChildren(link.getChild())) {
                    for (Explanation exp : this.getExplanations(link2)) {
                        if (!exp.getExplanationType().equals((Object)ExplanationType.INTERSECTION)) continue;
                        completeExplanations.add((CompletenessExplanation)exp);
                    }
                }
                for (AbstractExplanation abstractExplanation : completeExplanations) {
                    this.reasonRemoval(abstractExplanation, null);
                }
                this.internalAddLink(link);
            } else {
                this.pushNewLink(link);
            }
            this.doCompleteChecks();
            this.debugMode = false;
        }
    }

    @Override
    public void addLink(Link link) {
        if (link instanceof OBORestriction && ((OBORestriction)link).getCompletes()) {
            LinkedList<CompletenessExplanation> completeExplanations = new LinkedList<CompletenessExplanation>();
            for (Link link2 : this.getChildren(link.getChild())) {
                for (Explanation exp : this.getExplanations(link2)) {
                    if (!exp.getExplanationType().equals((Object)ExplanationType.INTERSECTION)) continue;
                    completeExplanations.add((CompletenessExplanation)exp);
                }
            }
            for (AbstractExplanation abstractExplanation : completeExplanations) {
                this.reasonRemoval(abstractExplanation, null);
            }
            this.internalAddLink(link);
        } else {
            this.pushNewLink(link);
        }
        this.doCompleteChecks();
        this.debugMode = false;
    }

    @Override
    public void removeLinks(Collection<Link> links) {
        for (Link link : links) {
            this.reasonRemoval(link);
            this.doCompleteChecks();
        }
    }

    @Override
    public void removeLink(Link link) {
        this.reasonRemoval(link);
        this.doCompleteChecks();
    }

    protected Collection<Explanation> getDependentExplanations(Link link) {
        Collection<Explanation> out = this.explanationDeps.get(link);
        if (out == null) {
            return Collections.emptySet();
        }
        return out;
    }

    protected void reasonRemoval(Link link) {
        Collection<Link> completeParents;
        this.impliedLinkDatabase.removeParent(link);
        Collection<Explanation> exps = this.explanationMap.get(link);
        if (exps != null) {
            Iterator<Explanation> it = exps.iterator();
            while (it.hasNext()) {
                Explanation exp = it.next();
                if (!exp.getExplanationType().equals((Object)ExplanationType.GIVEN)) continue;
                it.remove();
            }
            if (exps.size() == 0) {
                this.explanationMap.remove(link);
            }
        }
        if (link instanceof OBORestriction && ((OBORestriction)link).getCompletes() && (completeParents = this.intersectionMap.get(link.getChild())) != null) {
            completeParents.remove(link);
            if (completeParents.size() == 0) {
                this.intersectionMap.remove(link.getChild());
            }
        }
        Collection<Explanation> deps = this.getDependentExplanations(link);
        for (Explanation exp : new ArrayList<Explanation>(deps)) {
            boolean dead = exp.removeEvidence(link);
            if (!dead) continue;
            this.reasonRemoval(exp, link);
        }
    }

    protected void reasonRemoval(Explanation exp, Link justRemoved) {
        ArrayList<Link> evidenceLinks = new ArrayList<Link>(exp.getEvidence());
        if (justRemoved != null) {
            evidenceLinks.add(justRemoved);
        }
        for (Link link : evidenceLinks) {
            Collection<Explanation> exps = this.explanationDeps.get(link);
            if (exps == null) continue;
            exps.remove(exp);
            if (exps.size() != 0) continue;
            this.explanationDeps.remove(link);
        }
        PathCapable explainedObject = exp.getExplainedObject();
        Collection<Explanation> exps = this.getExplanations(explainedObject);
        exps.remove(exp);
        if (exps.size() == 0) {
            this.reasonRemoval(exp.getExplainedObject());
        }
    }

    protected void reasonRemoval(PathCapable pc) {
        if (pc instanceof Link) {
            this.reasonRemoval((Link)pc);
        }
    }

    @Override
    public long recache() {
        this.isRunning = true;
        this.cancelled = false;
        this.addLinkTime = 0L;
        this.existsTime = 0L;
        this.explainTime = 0L;
        this.reasonLinkTime = 0L;
        this.findLinkTime = 0L;
        this.expMapSetupTime = 0L;
        this.depExpMapSetupTime = 0L;
        this.findAttempts = 0;
        this.findHits = 0;
        this.fireStart();
        this.recaching = true;
        long time = System.currentTimeMillis();
        this.impliedLinkDatabase.clear();
        this.clearIntersectionMap();
        this.explanationMap.clear();
        this.explanationDeps.clear();
        this.newLinks = 0;
        LinkedList<LinkedObject> classes = new LinkedList<LinkedObject>();
        LinkedList<LinkedObject> properties = new LinkedList<LinkedObject>();
        int objCount = TermUtil.getObjectCount(this.linkDatabase);
        Iterator<IdentifiedObject> it = this.linkDatabase.getObjects().iterator();
        int i = 0;
        while (it.hasNext()) {
            IdentifiedObject io = it.next();
            if (this.cancelled) {
                return System.currentTimeMillis() - time;
            }
            if (io == null) {
                logger.info((Object)"NULL OBJECT IN DEFAULT OBJECT DATABASE!!!");
            }
            if (io instanceof OBOProperty) {
                properties.add((LinkedObject)io);
            } else if (io instanceof OBOClass) {
                classes.add((LinkedObject)io);
            }
            if (io instanceof LinkedObject) {
                LinkedObject lo = (LinkedObject)io;
                for (Relationship relationship : this.linkDatabase.getParents(lo)) {
                    if (!(relationship instanceof Link)) continue;
                    Link link = (Link)relationship;
                    if (this.cancelled) {
                        return System.currentTimeMillis() - time;
                    }
                    if (!TermUtil.isIntersection(link)) continue;
                    Collection<Link> completeParents = this.intersectionMap.get(link.getChild());
                    if (completeParents == null) {
                        completeParents = this.createSet();
                        this.intersectionMap.put(link.getChild(), completeParents);
                    }
                    completeParents.add(link);
                }
            }
            this.showProgress(100 * i / objCount, "Initializing database...");
            ++i;
        }
        Iterator<LinkedObject> it2 = this.intersectionMap.keySet().iterator();
        block2: while (it2.hasNext()) {
            LinkedObject lo = it2.next();
            if (this.cancelled) {
                return System.currentTimeMillis() - time;
            }
            Collection<Link> parents = this.intersectionMap.get(lo);
            for (Link link : parents) {
                if (this.cancelled) {
                    return System.currentTimeMillis() - time;
                }
                if (!TermUtil.isDangling(link)) continue;
                it2.remove();
                continue block2;
            }
        }
        this.showProgress(0, "Discovering genus/diff implications...");
        this.doGenusDifferentiaImplications();
        this.showProgress(0, "Calculating basic symmetry implications...");
        this.doSymmetryImplications();
        this.showProgress(0, "Calculating inversion implications...");
        this.doInversionImplications();
        if (this.cancelled) {
            return System.currentTimeMillis() - time;
        }
        this.showProgress(0, "Calculating transitive closure: properties...");
        this.doTransitiveClosure(properties);
        if (this.cancelled) {
            return System.currentTimeMillis() - time;
        }
        this.showProgress(0, "Calculating transitive closure: classes...");
        this.doTransitiveClosure(classes);
        if (this.cancelled) {
            return System.currentTimeMillis() - time;
        }
        properties = null;
        classes = null;
        this.doCompleteChecks();
        if (this.cancelled) {
            return System.currentTimeMillis() - time;
        }
        time = System.currentTimeMillis() - time;
        this.recaching = false;
        this.fireDone();
        this.isRunning = false;
        logger.info((Object)("   Total reasoner time = " + time + " ms"));
        return time;
    }

    public void cancel() {
        this.cancelled = true;
        this.isRunning = false;
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    protected void doGenusDifferentiaImplications() {
        for (LinkedObject lo : this.getIntersectionMap().keySet()) {
            Collection<Link> c = this.getIntersectionMap().get(lo);
            for (Link or : c) {
                if (this.cancelled) {
                    return;
                }
                this.doGenusDifferentiaImplications(or);
            }
        }
    }

    protected void doGenusDifferentiaImplications(Link or) {
        if (this.isSubPropertyOf(or.getType(), OBOProperty.IS_A)) {
            Link link = this.findOrCreateLink(or.getChild(), OBOProperty.IS_A, or.getParent());
            this.internalAddLink(link);
            GenusExplanation explanation = new GenusExplanation(or);
            this.explain(link, explanation);
        } else {
            Link link = this.findOrCreateLink(or.getChild(), or.getType(), or.getParent());
            this.internalAddLink(link);
            DifferentiaExplanation explanation = new DifferentiaExplanation(or);
            this.explain(link, explanation);
        }
    }

    protected void doSymmetryImplications() {
        Iterator<Link> it = TermUtil.getAllLinks(this.linkDatabase);
        while (it.hasNext()) {
            Link l = it.next();
            if (TermUtil.isIntersection(l) || !l.getType().isSymmetric()) continue;
            Link link = this.findOrCreateLink(l.getParent(), l.getType(), l.getChild());
            this.internalAddLink(link);
            SymmetryExplanation explanation = new SymmetryExplanation(l, link);
            this.explain(link, explanation);
        }
    }

    protected void doInversionImplications() {
        Iterator<Link> it = TermUtil.getAllLinks(this.linkDatabase);
        while (it.hasNext()) {
            Link l = it.next();
            if (TermUtil.isIntersection(l) || !l.getType().isAlwaysImpliesInverse()) continue;
            Collection inverseParents = this.getParentsOfType(l.getType(), OBOProperty.INVERSE_OF);
            for (LinkedObject lo : inverseParents) {
                if (!(lo instanceof OBOProperty)) continue;
                OBOProperty type = (OBOProperty)lo;
                Link link = this.findOrCreateLink(l.getParent(), type, l.getChild());
                this.internalAddLink(link);
                AlwaysImpliesInverseExplanation explanation = new AlwaysImpliesInverseExplanation(link, l);
                this.explain(link, explanation);
            }
        }
    }

    protected void doCompleteChecks() {
        int index = 1;
        do {
            this.newLinks = 0;
            this.showProgress(0, "Calculating completeness: pass " + index + "...");
            this.checkCompleteDefs();
            ++index;
        } while (this.newLinks > 0);
    }

    protected void checkCompleteDefs() {
        int i = 0;
        HashSet<LinkedObject> checkedThese = new HashSet<LinkedObject>();
        int mapSize = this.getIntersectionMap().size();
        for (LinkedObject lo : this.getIntersectionMap().keySet()) {
            LinkedObject candidate;
            if (this.cancelled) {
                return;
            }
            LinkedHashMap candidates = new LinkedHashMap();
            this.showProgress(i++ * 100 / mapSize, "Checking intersections for object " + i + " of " + mapSize);
            LinkedList<Link> completeLinks = new LinkedList<Link>();
            completeLinks.addAll(this.getIntersectionMap().get(lo));
            Relationship starterLink = null;
            int minSetSize = Integer.MAX_VALUE;
            for (Link completeLink : completeLinks) {
                int childCount = TermUtil.getChildCount(this, completeLink.getParent());
                if (childCount >= minSetSize) continue;
                starterLink = completeLink;
                minSetSize = childCount;
            }
            completeLinks.remove(starterLink);
            checkedThese.add(starterLink.getChild());
            if (starterLink == null) {
                logger.info((Object)"UNEXPECTED CONDITION: EMPTY COMPLETE DEF!");
            } else {
                Relationship completeLink = starterLink;
                Collection<Link> children = this.getChildren(completeLink.getParent());
                for (Link candidateLink : children) {
                    if (this.cancelled) {
                        return;
                    }
                    if (candidateLink.getChild().equals(lo) || TermUtil.isIntersection(candidateLink) || this.findLink(candidateLink.getChild(), completeLink.getType(), completeLink.getParent()) == null) continue;
                    Set evidence = (Set)candidates.get(candidateLink.getChild());
                    if (evidence == null) {
                        evidence = this.createSet();
                        candidates.put(candidateLink.getChild(), evidence);
                    }
                    evidence.add(new CompletenessMatch(candidateLink, (Link)completeLink));
                }
            }
            Iterator it2 = candidates.keySet().iterator();
            block3: while (it2.hasNext()) {
                if (this.cancelled) {
                    return;
                }
                candidate = (LinkedObject)it2.next();
                for (Link completeLink : completeLinks) {
                    Link candidateLink = this.findLink(candidate, completeLink.getType(), completeLink.getParent());
                    if (candidateLink != null) {
                        Collection<Object> evidence = (Collection)candidates.get(candidate);
                        if (evidence == null) {
                            evidence = this.createSet();
                            candidates.put(candidate, (Set)evidence);
                        }
                        evidence.add(new CompletenessMatch(candidateLink, completeLink));
                        continue;
                    }
                    it2.remove();
                    continue block3;
                }
            }
            it2 = candidates.keySet().iterator();
            while (it2.hasNext()) {
                if (this.cancelled) {
                    return;
                }
                candidate = (LinkedObject)it2.next();
                Collection matches = (Collection)candidates.get(candidate);
                Object matchParent = null;
                CompletenessExplanation exp = new CompletenessExplanation();
                for (CompletenessMatch cm : matches) {
                    if (this.cancelled) {
                        return;
                    }
                    matchParent = cm.getCompletenessLink().getChild();
                    exp.addMatch(cm);
                }
                LinkedObject candidateGenus = this.getGenus(candidate);
                if (candidateGenus != null && matchParent.equals(candidateGenus)) continue;
                Link newRel = this.findOrCreateLink(candidate, OBOProperty.IS_A, (LinkedObject)matchParent);
                if (!this.linkExists(newRel)) {
                    this.internalAddLink(newRel);
                    this.pushNewLink(newRel);
                }
                this.explain(newRel, exp);
            }
        }
    }

    public LinkedObject getGenus(LinkedObject candidate) {
        for (Link link : this.linkDatabase.getParents(candidate)) {
            if (!TermUtil.isIntersection(link) || !this.isSubPropertyOf(link.getType(), OBOProperty.IS_A)) continue;
            return link.getParent();
        }
        return null;
    }

    protected void cacheAllParents(LinkedObject lo, Collection<LinkedObject> cached) {
        if (cached.contains(lo)) {
            return;
        }
        cached.add(lo);
        LinkedList<Link> parents = new LinkedList<Link>(this.getParents(lo));
        for (Link link : parents) {
            if (this.cancelled) {
                return;
            }
            this.cacheAllParents(link.getParent(), cached);
        }
        for (Link link : parents) {
            if (this.cancelled) {
                return;
            }
            if (TermUtil.isIntersection(link)) continue;
            LinkedList<Link> grandParents = new LinkedList<Link>(this.getParents(link.getParent()));
            for (Link gpLink : grandParents) {
                Link newRel;
                if (TermUtil.isIntersection(gpLink) || (newRel = this.reasonLink(link, gpLink)) == null || newRel.getParent().equals(newRel.getChild()) && this.isSubPropertyOf(newRel.getType(), OBOProperty.IS_A)) continue;
                if (!this.linkExists(newRel)) {
                    this.internalAddLink(newRel);
                }
                TransitivityExplanation explanation = new TransitivityExplanation(link, gpLink);
                this.explain(newRel, explanation);
            }
        }
    }

    protected Link reasonLink(Link link, Link gpLink) {
        long time = System.currentTimeMillis();
        Link newRel = null;
        if (ReasonerUtil.generateTransitiveImplication(this, this.tempLink, link, gpLink)) {
            newRel = this.findOrCreateLink(this.tempLink.getChild(), this.tempLink.getType(), this.tempLink.getParent());
        }
        this.reasonLinkTime += System.currentTimeMillis() - time;
        return newRel;
    }

    protected void doTransitiveClosure(Collection<LinkedObject> objects) {
        HashSet<LinkedObject> seenem = new HashSet<LinkedObject>();
        Iterator<LinkedObject> it = objects.iterator();
        int i = 0;
        while (it.hasNext()) {
            if (this.cancelled) {
                return;
            }
            LinkedObject lo = it.next();
            this.cacheAllParents(lo, seenem);
            this.showProgress(100 * i / objects.size());
            ++i;
        }
    }

    public void pushLinksDown(Collection<Link> links, Link throughLink) {
        for (Link link : links) {
            OBORestriction newRel;
            if (link.equals(throughLink) || TermUtil.isIntersection(link) || (newRel = (OBORestriction)this.reasonLink(throughLink, link)) == null) continue;
            if (!this.linkExists(newRel)) {
                this.internalAddLink(newRel);
            }
            TransitivityExplanation explanation = new TransitivityExplanation(throughLink, link);
            this.explain(newRel, explanation);
            this.pushLink(newRel, new HashSet<Link>());
        }
    }

    protected void pushNewLink(Link link) {
        this.pushLink(link, new HashSet<Link>());
        LinkedList<Link> parents = new LinkedList<Link>();
        parents.addAll(this.getParents(link.getParent()));
        this.pushLinksDown(parents, link);
    }

    public void pushLink(Link link, Collection<Link> seenem) {
        if (TermUtil.isIntersection(link)) {
            logger.info((Object)"shouldn't push an intersection");
        }
        if (seenem.contains(link)) {
            return;
        }
        seenem.add(link);
        LinkedObject target = link.getChild();
        LinkedList<Link> children = new LinkedList<Link>();
        children.addAll(this.getChildren(target));
        for (Link childLink : children) {
            OBORestriction newRel;
            if (TermUtil.isIntersection(childLink) || (newRel = (OBORestriction)this.reasonLink(childLink, link)) == null) continue;
            boolean foundLink = this.linkExists(newRel);
            if (!foundLink) {
                this.internalAddLink(newRel);
            }
            TransitivityExplanation explanation = new TransitivityExplanation(childLink, link);
            this.explain(newRel, explanation);
            if (foundLink) continue;
            this.pushLink(newRel, seenem);
        }
    }

    @Override
    public Collection<Explanation> getExplanations(PathCapable pc) {
        if (!(pc instanceof Link)) {
            return Collections.emptySet();
        }
        Link link = (Link)pc;
        Collection<Explanation> explanations = null;
        explanations = this.explanationMap.get(link);
        if (explanations == null) {
            if (TermUtil.isImplied(link)) {
                return Collections.singleton(new ExternallyImpliedExplanation(link));
            }
            return Collections.singleton(new GivenExplanation(link));
        }
        if (TermUtil.containsLink(this.linkDatabase, link)) {
            LinkedList<Explanation> out = new LinkedList<Explanation>(explanations);
            out.add(new GivenExplanation(link));
            return out;
        }
        return explanations;
    }

    protected <T> Set<T> createSet() {
        if (this.useTinySet) {
            return new TinySet();
        }
        return new HashSet();
    }

    protected Collection<Explanation> getDependentExplanations(PathCapable pc) {
        Collection<Explanation> depEx = this.explanationDeps.get(pc);
        if (depEx == null) {
            return Collections.emptySet();
        }
        return depEx;
    }

    protected void explain(Link link, Explanation explanation) {
        if (explanation.getExplanationType().equals((Object)ExplanationType.GIVEN)) {
            throw new IllegalArgumentException();
        }
        long time = System.currentTimeMillis();
        if (explanation instanceof AbstractExplanation) {
            ((AbstractExplanation)explanation).setExplainedLink(link);
        }
        long time2 = System.currentTimeMillis();
        Collection<Explanation> explanations = this.explanationMap.get(link);
        if (explanations == null) {
            explanations = this.evidenceLinkedListMode ? new LinkedList<Explanation>() : this.createSet();
            this.explanationMap.put(link, explanations);
        }
        this.expMapSetupTime += System.currentTimeMillis() - time2;
        time2 = System.currentTimeMillis();
        for (Link evidence : explanation.getEvidence()) {
            Collection<Explanation> depExp = this.explanationDeps.get(evidence);
            if (depExp == null) {
                depExp = this.evidenceLinkedListMode ? new LinkedList<Explanation>() : this.createSet();
                this.explanationDeps.put(evidence, depExp);
            }
            depExp.add(explanation);
        }
        this.depExpMapSetupTime += System.currentTimeMillis() - time2;
        explanations.add(explanation);
        this.explainTime += System.currentTimeMillis() - time;
    }

    public static void main(String[] args) throws DataAdapterException {
        OBOSession session = TermUtil.getSession("/Users/jrichter/ontology/gene_ontology_edit.obo");
        ForwardChainingReasoner reasoner = new ForwardChainingReasoner();
        reasoner.setLinkDatabase(session.getLinkDatabase());
        for (int i = 0; i < 10; ++i) {
            reasoner.useTinySet = true;
            reasoner.neverFindMode = false;
            reasoner.evidenceLinkedListMode = false;
            long time = System.currentTimeMillis();
            reasoner.recache();
            logger.info((Object)("reasoned in " + (System.currentTimeMillis() - time) + " using defaults"));
            logger.info((Object)("  addlinktime = " + reasoner.addLinkTime));
            logger.info((Object)("  existsTime = " + reasoner.existsTime));
            logger.info((Object)("  explainTime = " + reasoner.explainTime));
            logger.info((Object)("     depExpMapSetupTime = " + reasoner.depExpMapSetupTime));
            logger.info((Object)("     expMapSetupTime = " + reasoner.expMapSetupTime));
            reasoner.useTinySet = false;
            reasoner.neverFindMode = true;
            reasoner.evidenceLinkedListMode = true;
            time = System.currentTimeMillis();
            reasoner.recache();
            logger.info((Object)("reasoned in " + (System.currentTimeMillis() - time) + " using never find and linked list mode"));
            logger.info((Object)("  addlinktime = " + reasoner.addLinkTime));
            logger.info((Object)("  existsTime = " + reasoner.existsTime));
            logger.info((Object)("  explainTime = " + reasoner.explainTime));
            logger.info((Object)("     depExpMapSetupTime = " + reasoner.depExpMapSetupTime));
            logger.info((Object)("     expMapSetupTime = " + reasoner.expMapSetupTime));
            logger.info((Object)("  reasonLinkTime = " + reasoner.reasonLinkTime));
            logger.info((Object)("  findLinkTime = " + reasoner.findLinkTime));
            logger.info((Object)("  findAttempts = " + reasoner.findAttempts));
            logger.info((Object)("  findHits = " + reasoner.findHits));
        }
        double objCount = session.getObjects().size();
        double linkCount = 0.0;
        for (IdentifiedObject io : session.getObjects()) {
            if (!(io instanceof LinkedObject)) continue;
            linkCount += (double)((LinkedObject)io).getParents().size();
        }
        logger.info((Object)("original avg. link count " + linkCount / objCount));
        linkCount = 0.0;
        for (IdentifiedObject io : reasoner.getObjects()) {
            if (!(io instanceof LinkedObject)) continue;
            linkCount += (double)reasoner.getParents((LinkedObject)io).size();
        }
        logger.info((Object)("reasoned avg. link count " + linkCount / objCount));
    }

    protected void fireDone() {
        for (ReasonerListener reasonerListener : this.reasonerListeners) {
            reasonerListener.reasoningFinished();
        }
    }

    protected void fireStart() {
        for (ReasonerListener reasonerListener : this.reasonerListeners) {
            reasonerListener.reasoningStarted();
        }
    }

    @Override
    public void addReasonerListener(ReasonerListener listener) {
        this.reasonerListeners.add(listener);
    }

    @Override
    public void removeReasonerListener(ReasonerListener listener) {
        this.reasonerListeners.remove(listener);
    }

    protected void showProgress(int percent, String message) {
        this.progressVal = percent;
        this.progressString = message;
    }

    protected void showProgress(int percent) {
        this.progressVal = percent;
    }

    @Override
    public IdentifiedObject getObject(String id) {
        return this.linkDatabase.getObject(id);
    }

    public String getProgressString() {
        return this.progressString;
    }

    public Number getProgressValue() {
        return this.progressVal;
    }
}

