/*
 * Decompiled with CFR 0.152.
 */
package org.obo.reasoner.impl;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.obo.datamodel.Link;
import org.obo.datamodel.OBOProperty;
import org.obo.reasoner.Explanation;
import org.obo.reasoner.ReasonedLinkDatabase;
import org.obo.reasoner.impl.AbstractExplanation;
import org.obo.reasoner.impl.AbstractReasonerRule;
import org.obo.reasoner.impl.DifferentiaExplanation;
import org.obo.reasoner.impl.GenusExplanation;
import org.obo.util.TermUtil;

public class GenusDifferentiaRule
extends AbstractReasonerRule {
    protected static final Logger logger = Logger.getLogger(GenusDifferentiaRule.class);

    public GenusDifferentiaRule() {
        this.setAllowIntersections(true);
    }

    @Override
    protected Collection<Explanation> doGetImplications(ReasonedLinkDatabase reasoner, Link newLink) {
        if (!TermUtil.isIntersection(newLink)) {
            return null;
        }
        Link out = this.createLink(newLink.getChild(), newLink.getType(), newLink.getParent());
        AbstractExplanation exp = reasoner.isSubPropertyOf(out.getType(), OBOProperty.IS_A) ? new GenusExplanation(newLink) : new DifferentiaExplanation(newLink);
        exp.setExplainedLink(out);
        ArrayList<Explanation> c = new ArrayList<Explanation>(1);
        c.add(exp);
        return c;
    }
}

