/*
 * Decompiled with CFR 0.152.
 */
package org.obo.reasoner.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Instance;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkDatabase;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.Namespace;
import org.obo.datamodel.NestedValue;
import org.obo.datamodel.OBOClass;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.PathCapable;
import org.obo.datamodel.impl.AbstractLinkDatabase;
import org.obo.datamodel.impl.OBORestrictionImpl;
import org.obo.reasoner.Explanation;
import org.obo.reasoner.ReasonedLinkDatabase;
import org.obo.reasoner.ReasonerListener;
import org.obo.reasoner.impl.AbstractExplanation;
import org.obo.reasoner.impl.TransitivityExplanation;
import org.obo.util.ReasonerUtil;
import org.obo.util.TermUtil;

public class OnTheFlyReasoner
extends AbstractLinkDatabase
implements ReasonedLinkDatabase {
    protected static final Logger logger = Logger.getLogger(OnTheFlyReasoner.class);
    protected LinkDatabase linkDatabase;
    protected Collection<ReasonerListener> reasonerListeners = new ArrayList<ReasonerListener>();
    protected Link scratch = new OBORestrictionImpl(true);

    public OnTheFlyReasoner() {
    }

    public OnTheFlyReasoner(LinkDatabase linkDatabase) {
        this.setLinkDatabase(linkDatabase);
    }

    protected void fireDone() {
        for (ReasonerListener reasonerListener : this.reasonerListeners) {
            reasonerListener.reasoningFinished();
        }
    }

    protected void fireStart() {
        for (ReasonerListener reasonerListener : this.reasonerListeners) {
            reasonerListener.reasoningStarted();
        }
    }

    @Override
    public void addReasonerListener(ReasonerListener listener) {
        this.reasonerListeners.add(listener);
    }

    @Override
    public void removeReasonerListener(ReasonerListener listener) {
        this.reasonerListeners.remove(listener);
    }

    @Override
    public Collection<LinkedObject> getParentsOfType(LinkedObject a, OBOProperty prop) {
        Collection<Link> parents = this.getParents(a);
        ArrayList<LinkedObject> out = new ArrayList<LinkedObject>();
        for (Link link : parents) {
            if (!this.isSubPropertyOf(link.getType(), prop)) continue;
            out.add(link.getParent());
        }
        return out;
    }

    @Override
    public Link hasRelationship(LinkedObject a, OBOProperty prop, LinkedObject b) {
        Collection<Link> parents = this.getParents(a);
        ArrayList out = new ArrayList();
        for (Link link : parents) {
            if (!this.isSubPropertyOf(link.getType(), prop) || !link.getParent().equals(b)) continue;
            return link;
        }
        return null;
    }

    @Override
    public boolean isInstanceOf(Instance a, OBOClass b) {
        if (a.getType() instanceof OBOClass) {
            return this.isSubclassOf((OBOClass)a.getType(), b);
        }
        return false;
    }

    @Override
    public boolean isRedundant(Link link) {
        return false;
    }

    @Override
    public Collection<Link> getChildren(LinkedObject lo) {
        ArrayList<Link> out = new ArrayList<Link>();
        Collection<Link> newImplications = this.linkDatabase.getChildren(lo);
        out.addAll(newImplications);
        while (newImplications.size() > 0) {
            newImplications = this.discoverImplications(this.linkDatabase, newImplications, false);
            out.addAll(newImplications);
        }
        return out;
    }

    protected Collection<Link> discoverImplications(LinkDatabase linkDatabase, Collection<Link> links, boolean traverseUp) {
        ArrayList<Link> out = new ArrayList<Link>();
        for (Link link : links) {
            ReasonerLink olink;
            if (traverseUp) {
                for (Link gpLink : linkDatabase.getParents(link.getParent())) {
                    if (!ReasonerUtil.generateTransitiveImplication(this, this.scratch, link, gpLink)) continue;
                    olink = new ReasonerLink(this.scratch.getChild(), this.scratch.getType(), this.scratch.getParent());
                    olink.addExplanation(new TransitivityExplanation(link, gpLink));
                    out.add(olink);
                }
                continue;
            }
            for (Link gcLink : linkDatabase.getChildren(link.getChild())) {
                if (!ReasonerUtil.generateTransitiveImplication(this, this.scratch, gcLink, link)) continue;
                olink = new ReasonerLink(this.scratch.getChild(), this.scratch.getType(), this.scratch.getParent());
                olink.addExplanation(new TransitivityExplanation(gcLink, link));
                out.add(olink);
            }
        }
        return out;
    }

    @Override
    public Collection<Link> getParents(LinkedObject lo) {
        ArrayList<Link> out = new ArrayList<Link>();
        Collection<Link> newImplications = this.linkDatabase.getParents(lo);
        out.addAll(newImplications);
        while (newImplications.size() > 0) {
            newImplications = this.discoverImplications(this.linkDatabase, newImplications, true);
            out.addAll(newImplications);
        }
        return out;
    }

    @Override
    public boolean isSubPropertyOf(OBOProperty a, OBOProperty b) {
        if (a.equals(b)) {
            return true;
        }
        return this.hasRelationship(a, OBOProperty.IS_A, b) != null;
    }

    @Override
    public boolean isSubclassOf(OBOClass a, OBOClass b) {
        if (a.equals(b)) {
            return true;
        }
        return this.hasRelationship(a, OBOProperty.IS_A, b) != null;
    }

    @Override
    public void addLink(Link link) {
    }

    @Override
    public void addLinks(Collection<Link> links) {
    }

    public void cancel() {
    }

    @Override
    public Collection<Explanation> getExplanations(PathCapable link) {
        if (link instanceof ReasonerLink) {
            return ((ReasonerLink)link).getExplanations();
        }
        return Collections.emptySet();
    }

    @Override
    public LinkDatabase getLinkDatabase() {
        return this.linkDatabase;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isRunning() {
        return false;
    }

    @Override
    public long recache() {
        this.fireStart();
        this.fireDone();
        return 0L;
    }

    @Override
    public void removeLink(Link link) {
    }

    @Override
    public void removeLinks(Collection<Link> link) {
    }

    @Override
    public void setLinkDatabase(LinkDatabase linkDatabase) {
        this.linkDatabase = linkDatabase;
    }

    @Override
    public Collection<IdentifiedObject> getObjects() {
        return this.linkDatabase.getObjects();
    }

    @Override
    public boolean hasChildren(LinkedObject lo) {
        return this.linkDatabase.hasChildren(lo);
    }

    @Override
    public boolean hasParents(LinkedObject lo) {
        return this.linkDatabase.hasParents(lo);
    }

    @Override
    public IdentifiedObject getObject(String id) {
        return this.linkDatabase.getObject(id);
    }

    public String getProgressString() {
        return null;
    }

    public Number getProgressValue() {
        return null;
    }

    public static class ReasonerLink
    implements Link {
        protected LinkedObject child;
        protected LinkedObject parent;
        protected LinkedObject ancestor;
        protected OBOProperty type;
        protected boolean lookedAt;
        protected ArrayList<AbstractExplanation> explanations;
        protected String id;
        protected int hash;

        public ReasonerLink(LinkedObject child, OBOProperty type, LinkedObject parent) {
            this.child = child;
            this.type = type;
            this.parent = parent;
            this.id = child.getID() + '-' + type.getID() + "->" + parent.getID();
            this.hash = child.hashCode() + type.hashCode() + parent.hashCode();
        }

        public Collection<AbstractExplanation> getExplanations() {
            if (this.explanations == null) {
                return Collections.emptyList();
            }
            return this.explanations;
        }

        @Override
        public Object clone() {
            throw new UnsupportedOperationException();
        }

        public void addExplanation(AbstractExplanation exp) {
            exp.setExplainedLink(this);
            if (this.explanations == null) {
                this.explanations = new ArrayList(5);
            }
            this.explanations.add(exp);
        }

        public void removeExplanation(AbstractExplanation exp) {
            if (this.explanations != null) {
                this.explanations.remove(exp);
            }
        }

        @Override
        public boolean isImplied() {
            return true;
        }

        @Override
        public String getID() {
            return this.id;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o instanceof Link) {
                return TermUtil.equals(this, (Link)o);
            }
            return false;
        }

        @Override
        public void setNestedValue(NestedValue nv) {
        }

        @Override
        public NestedValue getNestedValue() {
            return null;
        }

        @Override
        public boolean isAnonymous() {
            return false;
        }

        @Override
        public void setNamespace(Namespace namespace) {
        }

        @Override
        public Namespace getNamespace() {
            return null;
        }

        @Override
        public LinkedObject getChild() {
            return this.child;
        }

        @Override
        public void setChild(LinkedObject child) {
            throw new UnsupportedOperationException();
        }

        @Override
        public LinkedObject getParent() {
            return this.parent;
        }

        @Override
        public void setParent(LinkedObject parent) {
            throw new UnsupportedOperationException();
        }

        @Override
        public OBOProperty getType() {
            return this.type;
        }

        @Override
        public void setType(OBOProperty type) {
            throw new UnsupportedOperationException();
        }

        public boolean isLookedAt() {
            return this.lookedAt;
        }

        public void setLookedAt(boolean lookedAt) {
            this.lookedAt = lookedAt;
        }
    }
}

