/*
 * Decompiled with CFR 0.152.
 */
package org.obo.reasoner.impl;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.bbop.util.TinySet;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.jena.OWLReasoner;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.utils.ATermUtils;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Instance;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.MutableLinkDatabase;
import org.obo.datamodel.OBOClass;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.OBORestriction;
import org.obo.datamodel.PathCapable;
import org.obo.datamodel.impl.OBORestrictionImpl;
import org.obo.reasoner.Explanation;
import org.obo.reasoner.impl.AbstractReasoner;
import org.obo.util.TermUtil;

public class PelletWrappedReasoner
extends AbstractReasoner {
    protected static final Logger logger = Logger.getLogger(PelletWrappedReasoner.class);
    private static final long serialVersionUID = -1L;
    protected OWLReasoner owlReasoner;
    public KnowledgeBase kb;
    protected Taxonomy tax;
    protected Map<String, ATermAppl> idToATerm = new HashMap<String, ATermAppl>();
    protected Map<ATermAppl, IdentifiedObject> aTermToObject = new HashMap<ATermAppl, IdentifiedObject>();
    protected Map<IdentifiedObject, Collection<ATerm>> objectToEquivATermSet = new HashMap<IdentifiedObject, Collection<ATerm>>();
    protected Map<ATermAppl, Link> namedRestrToLink = new HashMap<ATermAppl, Link>();
    protected MutableLinkDatabase impliedLinkDatabase;

    public ATermAppl makeATerm(IdentifiedObject lo) {
        String id = lo.getID();
        ATermAppl aterm = this.idToATerm.get(id);
        if (aterm != null) {
            return aterm;
        }
        aterm = ATermUtils.makeTermAppl((String)id);
        this.idToATerm.put(id, aterm);
        this.aTermToObject.put(aterm, lo);
        if (TermUtil.isClass(lo)) {
            this.kb.addClass(aterm);
        } else if (TermUtil.isProperty(lo)) {
            this.kb.addObjectProperty((ATerm)aterm);
            if (((OBOProperty)lo).isTransitive()) {
                this.kb.addTransitiveProperty(aterm);
            }
            if (((OBOProperty)lo).isSymmetric()) {
                this.kb.addSymmetricProperty(aterm);
            }
            if (((OBOProperty)lo).getTransitiveOver() != null) {
                ArrayList<ATermAppl> chain = new ArrayList<ATermAppl>();
                chain.add(aterm);
                chain.add(this.makeATerm(((OBOProperty)lo).getTransitiveOver()));
            }
        } else {
            this.kb.addIndividual(aterm);
        }
        return aterm;
    }

    protected IdentifiedObject objectFromATerm(ATermAppl a) {
        return this.aTermToObject.get(a);
    }

    @Override
    public void addLink(Link link) {
        LinkedObject child = link.getChild();
        LinkedObject parent = link.getParent();
        OBOProperty type = link.getType();
        ATermAppl c = this.makeATerm(child);
        ATermAppl p = this.makeATerm(parent);
        if (link instanceof OBORestriction) {
            OBORestriction rlink = (OBORestriction)link;
            if (rlink.getType().equals(OBOProperty.DISJOINT_FROM)) {
                this.kb.addDisjointClass(c, p);
                return;
            }
            if (rlink.getType().equals(OBOProperty.INVERSE_OF)) {
                this.kb.addInverseProperty(c, p);
                return;
            }
            if (rlink.getCompletes()) {
                Collection<ATerm> ecterms = this.objectToEquivATermSet.get(child);
                if (ecterms == null) {
                    ecterms = new LinkedList<ATerm>();
                    this.objectToEquivATermSet.put(child, ecterms);
                }
                if (type.equals(OBOProperty.IS_A)) {
                    ecterms.add((ATerm)p);
                } else {
                    ATermAppl t = this.makeATerm(type);
                    ATermAppl restr = ATermUtils.makeSomeValues((ATerm)t, (ATerm)p);
                    ecterms.add((ATerm)restr);
                }
                logger.info((Object)("ecterms=" + ecterms.toString()));
            } else if (type.equals(OBOProperty.IS_A)) {
                if (link.getChild() instanceof OBOProperty) {
                    this.kb.addSubProperty((ATerm)c, p);
                } else {
                    this.kb.addSubClass(c, p);
                }
            } else {
                ATermAppl t = this.makeATerm(type);
                if (!(link.getChild() instanceof OBOProperty)) {
                    ATermAppl restr = ATermUtils.makeSomeValues((ATerm)t, (ATerm)p);
                    this.kb.addSubClass(c, restr);
                }
            }
        }
    }

    public void addProperty(OBOProperty p) {
        if (p.equals(OBOProperty.IS_A)) {
            return;
        }
        ATermAppl atermProp = this.makeATerm(p);
        if (p.isTransitive()) {
            ATermUtils.makeTransitive((ATerm)atermProp);
        }
        this.kb.addProperty(atermProp);
    }

    @Override
    public Collection<Link> getChildren(LinkedObject lo) {
        ATermAppl aterm = this.makeATerm(lo);
        Set equivClassSetSet = this.tax.getSubs(aterm, false);
        TinySet s = new TinySet();
        for (Set ecs : equivClassSetSet) {
            for (ATermAppl xATerm : ecs) {
                if (ATermUtils.isBottom((ATermAppl)xATerm)) {
                    logger.info((Object)"ignoring BOTTOM");
                    continue;
                }
                LinkedObject x = (LinkedObject)this.objectFromATerm(xATerm);
                Link newRel = this.findOrCreateLink(x, OBOProperty.IS_A, lo);
                s.add((Object)newRel);
            }
        }
        return s;
    }

    protected Link findOrCreateLink(LinkedObject child, OBOProperty type, LinkedObject parent) {
        OBORestrictionImpl out = new OBORestrictionImpl(child, type, parent, true);
        return out;
    }

    public Collection<OBOProperty> getSuperProperties(OBOProperty p) {
        ATermAppl aterm = this.makeATerm(p);
        Set equivPropSetSet = this.kb.getSuperProperties(aterm, false);
        TinySet s = new TinySet();
        for (Set ecs : equivPropSetSet) {
            for (ATermAppl parentATerm : ecs) {
                if (ATermUtils.isTop((ATermAppl)parentATerm)) {
                    logger.info((Object)"ignoring TOP");
                    continue;
                }
                OBOProperty parent = (OBOProperty)this.objectFromATerm(parentATerm);
                s.add(parent);
            }
        }
        return s;
    }

    @Override
    public Collection<Link> getParents(LinkedObject lo) {
        ATermAppl aterm = this.makeATerm(lo);
        Set equivClassSetSet = this.tax.getSupers(aterm, false);
        TinySet s = new TinySet();
        for (Set ecs : equivClassSetSet) {
            for (ATermAppl parentATerm : ecs) {
                if (ATermUtils.isTop((ATermAppl)parentATerm)) continue;
                Link plink = this.namedRestrToLink.get(parentATerm);
                if (plink == null) {
                    LinkedObject parent = (LinkedObject)this.objectFromATerm(parentATerm);
                    Link newRel = this.findOrCreateLink(lo, OBOProperty.IS_A, parent);
                    s.add(newRel);
                    continue;
                }
                s.add(this.findOrCreateLink(lo, plink.getType(), plink.getParent()));
            }
        }
        return s;
    }

    @Override
    public Link hasRelationship(LinkedObject a, OBOProperty b, LinkedObject c) {
        if (b.isBuiltIn()) {
            for (Link link : a.getParents()) {
                if (!link.getType().equals(b) || !link.getParent().equals(c)) continue;
                return link;
            }
        }
        return super.hasRelationship(a, b, c);
    }

    @Override
    public boolean isInstanceOf(Instance a, OBOClass b) {
        return false;
    }

    @Override
    public boolean isSubPropertyOf(OBOProperty a, OBOProperty b) {
        if (a.equals(b)) {
            return true;
        }
        for (OBOProperty p : this.getSuperProperties(a)) {
            if (!p.getID().equals(b.getID())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSubclassOf(OBOClass a, OBOClass b) {
        return false;
    }

    @Override
    public void removeLink(Link link) {
    }

    @Override
    public void removeLinks(Collection<Link> links) {
    }

    protected void setEquivalentClasses() {
        for (IdentifiedObject lo : this.objectToEquivATermSet.keySet()) {
            String id = lo.getID();
            ATermAppl aterm = this.idToATerm.get(id);
            Collection<ATerm> ecaterms = this.objectToEquivATermSet.get(lo);
            ATermList tl = ATermUtils.makeList(ecaterms);
            logger.info((Object)("tl=" + tl));
            ATermAppl ec = ATermUtils.makeAnd((ATermList)tl);
            this.kb.addEquivalentClass(aterm, ec);
            logger.info((Object)("EC " + aterm + "," + ec));
        }
    }

    @Override
    public long recache() {
        long initTime = System.nanoTime();
        logger.info((Object)"recaching. getting OWL reasoner...");
        this.owlReasoner = new OWLReasoner();
        logger.info((Object)("set OWL reasoner =   " + this.owlReasoner));
        this.kb = this.owlReasoner.getKB();
        logger.info((Object)("kb = " + this.kb));
        this.idToATerm = new HashMap<String, ATermAppl>();
        this.aTermToObject = new HashMap<ATermAppl, IdentifiedObject>();
        this.objectToEquivATermSet = new HashMap<IdentifiedObject, Collection<ATerm>>();
        this.namedRestrToLink = new HashMap<ATermAppl, Link>();
        HashSet<OBOProperty> props = new HashSet<OBOProperty>();
        for (IdentifiedObject io : this.linkDatabase.getObjects()) {
            if (io.isBuiltIn()) continue;
            if (io instanceof LinkedObject) {
                for (Link link : this.linkDatabase.getParents((LinkedObject)io)) {
                    this.addLink(link);
                }
            }
            if (!(io instanceof OBOProperty)) continue;
            this.addProperty((OBOProperty)io);
            props.add((OBOProperty)io);
        }
        for (OBOProperty prop : props) {
            for (IdentifiedObject io : this.linkDatabase.getObjects()) {
                if (io.isBuiltIn() || !(io instanceof LinkedObject)) continue;
                ATermAppl t = this.makeATerm(prop);
                ATermAppl p = this.makeATerm(io);
                ATermAppl namedRestr = ATermUtils.makeTermAppl((String)(prop.getID() + "---" + io.getID()));
                ATermAppl fakeChild = this.makeATerm(io);
                ATermAppl restr = ATermUtils.makeSomeValues((ATerm)t, (ATerm)p);
                this.kb.addEquivalentClass(namedRestr, restr);
                this.kb.addClass(namedRestr);
                this.namedRestrToLink.put(namedRestr, this.findOrCreateLink(null, prop, (LinkedObject)io));
            }
        }
        this.setEquivalentClasses();
        this.owlReasoner.classify();
        this.owlReasoner.realize();
        this.tax = this.kb.getTaxonomy();
        long totalTime = System.nanoTime() - initTime;
        logger.info((Object)("   Total reasoner time = " + (double)totalTime / 1000000.0 + " ms"));
        return 0L;
    }

    @Override
    public Collection<Explanation> getExplanations(PathCapable pc) {
        return null;
    }

    @Override
    public boolean hasChildren(LinkedObject lo) {
        return false;
    }

    @Override
    public boolean hasParents(LinkedObject lo) {
        return false;
    }

    @Override
    protected void doAddLink(Link link) {
    }

    @Override
    protected void doReasoning() {
    }

    @Override
    protected void doAddLinks(Collection<Link> links) {
    }
}

