/*
 * Decompiled with CFR 0.152.
 */
package org.obo.reasoner.impl;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.bbop.util.MultiHashMap;
import org.bbop.util.MultiMap;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOProperty;
import org.obo.reasoner.Explanation;
import org.obo.reasoner.ReasonedLinkDatabase;
import org.obo.reasoner.impl.AbstractReasonerRule;
import org.obo.reasoner.impl.PropertyIntersectionExplanation;
import org.obo.util.TermUtil;

public class PropertyIntersectionRule
extends AbstractReasonerRule {
    protected static final Logger logger = Logger.getLogger(PropertyIntersectionRule.class);
    protected MultiMap<OBOProperty, OBOProperty> propertyIntersectionMap;
    protected MultiMap<OBOProperty, OBOProperty> hintMap;

    @Override
    public void init(ReasonedLinkDatabase reasoner) {
        super.init(reasoner);
        this.buildPropertyIntersectionMap(reasoner);
    }

    protected void buildPropertyIntersectionMap(ReasonedLinkDatabase reasoner) {
        this.propertyIntersectionMap = new MultiHashMap();
        this.hintMap = new MultiHashMap();
        for (IdentifiedObject io : reasoner.getObjects()) {
            if (!(io instanceof OBOProperty)) continue;
            OBOProperty p = (OBOProperty)io;
            for (Link link : p.getParents()) {
                if (!TermUtil.isIntersection(link)) continue;
                this.propertyIntersectionMap.add((Object)p, (Object)((OBOProperty)link.getParent()));
                this.hintMap.add((Object)((OBOProperty)link.getParent()), (Object)p);
            }
        }
    }

    @Override
    protected Collection<Explanation> doGetImplications(ReasonedLinkDatabase reasoner, Link newLink) {
        Collection candidateProperties = (Collection)this.hintMap.get((Object)newLink.getType());
        ArrayList<Explanation> out = new ArrayList<Explanation>(1);
        if (candidateProperties.size() == 0) {
            return out;
        }
        LinkedObject newLinkChild = newLink.getChild();
        LinkedObject newLinkParent = newLink.getParent();
        for (OBOProperty p : candidateProperties) {
            ArrayList<Link> supportingLinks = new ArrayList<Link>(candidateProperties.size());
            boolean failed = false;
            Collection propertyIntersectionElements = (Collection)this.propertyIntersectionMap.get((Object)p);
            for (OBOProperty pie : propertyIntersectionElements) {
                Link matchLink = reasoner.hasRelationship(newLinkChild, pie, newLinkParent);
                if (matchLink == null) {
                    failed = true;
                    break;
                }
                supportingLinks.add(matchLink);
            }
            if (failed) continue;
            Link genLink = this.createLink(newLinkChild, p, newLinkParent);
            PropertyIntersectionExplanation exp = new PropertyIntersectionExplanation();
            exp.setExplainedLink(genLink);
            for (Link supportingLink : supportingLinks) {
                exp.addEvidence(supportingLink);
            }
            out.add(exp);
        }
        return out;
    }
}

