/*
 * Decompiled with CFR 0.152.
 */
package org.obo.reasoner.impl;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.obo.datamodel.Link;
import org.obo.datamodel.impl.OBORestrictionImpl;
import org.obo.reasoner.Explanation;
import org.obo.reasoner.ReasonedLinkDatabase;
import org.obo.reasoner.impl.AbstractReasonerRule;
import org.obo.reasoner.impl.TransitivityExplanation;
import org.obo.util.ReasonerUtil;
import org.obo.util.TermUtil;

public class SimpleTransitivityRule
extends AbstractReasonerRule {
    protected static final Logger logger = Logger.getLogger(SimpleTransitivityRule.class);
    protected static Link temp = new OBORestrictionImpl();
    long implicationTime;
    long fetchTime;
    long expConstructTime;
    protected static TransitivityExplanation scratchExp = new TransitivityExplanation();

    @Override
    public void init(ReasonedLinkDatabase reasoner) {
        super.init(reasoner);
        this.implicationTime = 0L;
        this.fetchTime = 0L;
        this.expConstructTime = 0L;
    }

    @Override
    public Collection<Explanation> doGetImplications(ReasonedLinkDatabase reasoner, Link link) {
        LinkedList<Explanation> out = new LinkedList<Explanation>();
        long time = System.nanoTime();
        Collection<Link> parents = reasoner.getParents(link.getParent());
        this.fetchTime += System.nanoTime() - time;
        for (Link gpLink : parents) {
            time = System.nanoTime();
            boolean success = ReasonerUtil.generateTransitiveImplication(reasoner, temp, link, gpLink);
            this.implicationTime += System.nanoTime() - time;
            if (!success) continue;
            time = System.nanoTime();
            TransitivityExplanation exp = this.createExplanation(reasoner, temp, link, gpLink);
            this.expConstructTime += System.nanoTime() - time;
            out.add(exp);
        }
        time = System.nanoTime();
        Collection<Link> children = reasoner.getChildren(link.getChild());
        this.fetchTime += System.nanoTime() - time;
        for (Link gcLink : children) {
            if (TermUtil.isIntersection(gcLink)) continue;
            time = System.nanoTime();
            boolean success = ReasonerUtil.generateTransitiveImplication(reasoner, temp, gcLink, link);
            this.implicationTime += System.nanoTime() - time;
            if (!success) continue;
            time = System.nanoTime();
            TransitivityExplanation exp = this.createExplanation(reasoner, temp, gcLink, link);
            this.expConstructTime += System.nanoTime() - time;
            out.add(exp);
        }
        return out;
    }

    protected TransitivityExplanation createExplanation(ReasonedLinkDatabase reasoner, Link temp, Link link, Link gpLink) {
        return new TransitivityExplanation(this.createLink(temp.getChild(), temp.getType(), temp.getParent()), link, gpLink);
    }

    public String toString() {
        return "Transitivity rule (implicationTime = " + (double)this.implicationTime / 1000000.0 + ", expConstTime = " + (double)this.expConstructTime / 1000000.0 + ", fetchTime = " + (double)this.fetchTime / 1000000.0 + ")";
    }

    protected void pushLinkDown(ReasonedLinkDatabase reasoner, Link link, Collection<Explanation> out, Collection<Link> seenem) {
        if (seenem.contains(link)) {
            return;
        }
        seenem.add(link);
        Collection<Link> children = reasoner.getChildren(link.getChild());
        for (Link gcLink : children) {
            TransitivityExplanation exp;
            if (TermUtil.isIntersection(gcLink) || !ReasonerUtil.generateTransitiveImplication(reasoner, temp, gcLink, link) || ReasonerUtil.containsExplanation(reasoner, exp = new TransitivityExplanation(this.createLink(temp.getChild(), temp.getType(), temp.getParent()), gcLink, link))) continue;
            out.add(exp);
            this.pushLinkDown(reasoner, gcLink, out, seenem);
        }
    }
}

