/*
 * Decompiled with CFR 0.152.
 */
package org.obo.reasoner.impl;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOProperty;
import org.obo.reasoner.Explanation;
import org.obo.reasoner.ReasonedLinkDatabase;
import org.obo.reasoner.impl.AbstractReasonerRule;
import org.obo.reasoner.impl.TransitiveOverExplanation;

public class TransitiveOverRule
extends AbstractReasonerRule {
    protected static final Logger logger = Logger.getLogger(TransitiveOverRule.class);

    public TransitiveOverRule() {
        this.setAllowIntersections(true);
    }

    @Override
    protected Collection<Explanation> doGetImplications(ReasonedLinkDatabase reasoner, Link newLink) {
        OBOProperty overProp = newLink.getType().getTransitiveOver();
        if (overProp == null) {
            return null;
        }
        ArrayList<Explanation> c = new ArrayList<Explanation>();
        for (LinkedObject parent : reasoner.getParentsOfType(newLink.getParent(), overProp)) {
            Link out = this.createLink(newLink.getChild(), newLink.getType(), parent);
            TransitiveOverExplanation exp = new TransitiveOverExplanation(newLink);
            exp.setExplainedLink(out);
            c.add(exp);
        }
        return c;
    }
}

