/*
 * Decompiled with CFR 0.152.
 */
package org.obo.reasoner.impl;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.obo.datamodel.Link;
import org.obo.reasoner.ExplanationType;
import org.obo.reasoner.impl.AbstractExplanation;

public class TransitivityExplanation
extends AbstractExplanation {
    protected static final Logger logger = Logger.getLogger(TransitivityExplanation.class);
    private static final long serialVersionUID = -4952593548062292144L;
    protected Link directLink;
    protected Link extensionLink;

    public TransitivityExplanation(Link explainedLink, Link directLink, Link extensionLink) {
        this(directLink, extensionLink);
        this.setExplainedLink(explainedLink);
    }

    public TransitivityExplanation() {
    }

    public TransitivityExplanation(Link directLink, Link extensionLink) {
        if (!directLink.getParent().equals(extensionLink.getChild())) {
            throw new IllegalArgumentException();
        }
        this.directLink = directLink;
        this.extensionLink = extensionLink;
    }

    public Link getDirectLink() {
        return this.directLink;
    }

    public Link getExtensionLink() {
        return this.extensionLink;
    }

    @Override
    public Collection<Link> getEvidence() {
        ArrayList<Link> out = new ArrayList<Link>(2);
        out.add(this.directLink);
        out.add(this.extensionLink);
        return out;
    }

    @Override
    public void addEvidence(Link link) {
        super.addEvidence(link);
    }

    @Override
    public boolean removeEvidence(Link link) {
        if (this.directLink.equals(link)) {
            this.directLink = null;
            return true;
        }
        if (this.extensionLink.equals(link)) {
            this.extensionLink = null;
            return true;
        }
        return false;
    }

    @Override
    public ExplanationType getExplanationType() {
        return ExplanationType.TRANSITIVITY;
    }

    @Override
    public String toString() {
        return "TRANSITIVITY: " + this.explainedLink + " from " + this.extensionLink + " over " + this.directLink;
    }
}

