/*
 * Decompiled with CFR 0.152.
 */
package org.obo.reasoner.impl;

import java.util.Collection;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.bbop.util.Subset;
import org.bbop.util.VectorFilter;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkDatabase;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.impl.AbstractLinkDatabase;
import org.obo.util.ReasonerUtil;

public class TrimmedLinkDatabase
extends AbstractLinkDatabase
implements LinkDatabase {
    protected static final Logger logger = Logger.getLogger(TrimmedLinkDatabase.class);
    protected LinkDatabase linkDatabase;
    protected boolean enableTrimming = true;
    public static long trimTime = 0L;
    public boolean normalTrimming = true;

    public void setEnableTrimming(boolean enableTrimming) {
        this.enableTrimming = enableTrimming;
    }

    @Override
    public Collection<Link> getChildren(LinkedObject lo) {
        if (!this.enableTrimming) {
            return this.linkDatabase.getChildren(lo);
        }
        VectorFilter<Link> filter = new VectorFilter<Link>(){

            public boolean satisfies(Link inLink) {
                boolean trim = TrimmedLinkDatabase.this.normalTrimming ? !ReasonerUtil.shouldBeTrimmed(TrimmedLinkDatabase.this.linkDatabase, inLink) : !ReasonerUtil.shouldBeTrimmedNew(TrimmedLinkDatabase.this.linkDatabase, inLink);
                return trim;
            }
        };
        Collection<Link> children = this.linkDatabase.getChildren(lo);
        Subset out = new Subset((VectorFilter)filter, children, false);
        return out;
    }

    @Override
    public Collection<Link> getParents(LinkedObject lo) {
        if (!this.enableTrimming) {
            return this.linkDatabase.getParents(lo);
        }
        VectorFilter<Link> filter = new VectorFilter<Link>(){

            public boolean satisfies(Link inLink) {
                boolean trim = TrimmedLinkDatabase.this.normalTrimming ? !ReasonerUtil.shouldBeTrimmed(TrimmedLinkDatabase.this.linkDatabase, inLink) : !ReasonerUtil.shouldBeTrimmedNew(TrimmedLinkDatabase.this.linkDatabase, inLink);
                return trim;
            }
        };
        Collection<Link> parents = this.linkDatabase.getParents(lo);
        Subset out = new Subset((VectorFilter)filter, parents, false);
        return out;
    }

    @Override
    public Collection<IdentifiedObject> getObjects() {
        if (this.linkDatabase == null) {
            logger.debug((Object)"TrimmedLinkDatabase.getObjects -- linkDatabase ==null");
            return Collections.emptySet();
        }
        return this.linkDatabase.getObjects();
    }

    @Override
    public IdentifiedObject getObject(String id) {
        logger.debug((Object)"TrimmedLinkDatabase.getObject");
        return this.linkDatabase.getObject(id);
    }

    public LinkDatabase getLinkDatabase() {
        return this.linkDatabase;
    }

    public void setLinkDatabase(LinkDatabase linkDatabase) {
        this.linkDatabase = linkDatabase;
    }

    public TrimmedLinkDatabase(LinkDatabase linkDatabase) {
        this.linkDatabase = linkDatabase;
    }

    @Override
    public boolean hasChildren(LinkedObject lo) {
        return this.linkDatabase.hasChildren(lo);
    }

    @Override
    public boolean hasParents(LinkedObject lo) {
        return this.linkDatabase.hasParents(lo);
    }

    protected static class LinkTarget {
        protected OBOProperty type;
        protected LinkedObject parent;

        public LinkTarget() {
        }

        public LinkTarget(Link link) {
            this.type = link.getType();
            this.parent = link.getParent();
        }

        public int hashCode() {
            return this.type.hashCode() + this.parent.hashCode();
        }

        public boolean equals(Object o) {
            return ((LinkTarget)o).parent.equals(this.parent) && ((LinkTarget)o).type.equals(this.type);
        }

        public void setType(OBOProperty type) {
            this.type = type;
        }

        public void setParent(LinkedObject parent) {
            this.parent = parent;
        }
    }
}

