/*
 * Decompiled with CFR 0.152.
 */
package org.obo.reasoner.rbr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;
import org.bbop.util.MultiHashMap;
import org.bbop.util.MultiMap;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.OBORestriction;
import org.obo.datamodel.impl.OBORestrictionImpl;
import org.obo.reasoner.Explanation;
import org.obo.reasoner.ReasonedLinkDatabase;
import org.obo.reasoner.impl.CompletenessExplanation;
import org.obo.reasoner.impl.CompletenessMatch;
import org.obo.reasoner.rbr.AbstractExplanation;
import org.obo.reasoner.rbr.AbstractRule;
import org.obo.reasoner.rbr.DifferentiaExplanation;
import org.obo.reasoner.rbr.GenusExplanation;
import org.obo.util.TermUtil;

public class IntersectionRule
extends AbstractRule {
    protected static final Logger logger = Logger.getLogger(IntersectionRule.class);
    protected boolean isFirstPass = true;
    public long findBestLinkTime = 0L;
    protected MultiMap<LinkedObject, Link> intersectionMap;
    protected Map<LinkedObject, Link> bestLinkMap;

    @Override
    public void init(ReasonedLinkDatabase reasoner) {
        super.init(reasoner);
        this.buildIntersectionMap(reasoner);
    }

    protected void buildIntersectionMap(ReasonedLinkDatabase reasoner) {
        this.intersectionMap = new MultiHashMap();
        HashSet<LinkedObject> skipset = new HashSet<LinkedObject>();
        for (IdentifiedObject io : reasoner.getObjects()) {
            if (io instanceof LinkedObject) {
                LinkedObject lo = (LinkedObject)io;
                for (Link link : lo.getParents()) {
                    if (!TermUtil.isIntersection(link)) continue;
                    this.intersectionMap.add((Object)lo, (Object)link);
                    OBORestriction r = (OBORestriction)link;
                    if (r.getCardinality() != null || r.getMinCardinality() != null && r.getMinCardinality() != 1 || r.getMaxCardinality() != null) {
                        logger.info((Object)("Ignoring xp def of " + lo + " Reason: cardinality "));
                        skipset.add(lo);
                    }
                    if (r.getAdditionalArguments() == null || r.getAdditionalArguments().size() <= 0) continue;
                    logger.info((Object)("Ignoring xp def of " + lo + " Reason: n-ary relations "));
                    skipset.add(lo);
                }
            }
            for (LinkedObject s : skipset) {
                this.intersectionMap.remove((Object)s);
            }
        }
    }

    @Override
    public Collection<Explanation> getNewInferences(ReasonedLinkDatabase reasoner) {
        OBOProperty prop;
        long time = System.nanoTime();
        ArrayList<Explanation> expls = new ArrayList<Explanation>();
        if (this.isFirstPass) {
            long itime = System.nanoTime();
            this.bestLinkMap = new HashMap<LinkedObject, Link>();
            this.isFirstPass = false;
            for (LinkedObject xp : this.intersectionMap.keySet()) {
                Integer minSize = null;
                Link bestLink = null;
                for (Link link : (Collection)this.intersectionMap.get((Object)xp)) {
                    prop = link.getType();
                    Link out = this.createLink(link.getChild(), prop, link.getParent());
                    AbstractExplanation exp = prop.equals(OBOProperty.IS_A) ? new GenusExplanation(link) : new DifferentiaExplanation(link);
                    exp.setExplainedLink(out);
                    expls.add(exp);
                    int numLinks = reasoner.getChildren(link.getParent()).size();
                    if (minSize != null && numLinks >= minSize) continue;
                    minSize = numLinks;
                    bestLink = link;
                }
                this.bestLinkMap.put(xp, bestLink);
            }
            long xpInitTime = System.nanoTime() - itime;
        }
        for (LinkedObject xp : this.intersectionMap.keySet()) {
            HashSet<LinkedObject> candidateSubClasses = new HashSet<LinkedObject>();
            Link bestLink = null;
            bestLink = this.bestLinkMap.containsKey(xp) ? this.bestLinkMap.get(xp) : (Link)((Collection)this.intersectionMap.get((Object)xp)).iterator().next();
            Collection<Link> rchildren = reasoner.getChildren(bestLink.getParent());
            OBORestrictionImpl reflexiveLink = null;
            if (bestLink.getType().equals(OBOProperty.IS_A) || bestLink.getType().isReflexive()) {
                reflexiveLink = new OBORestrictionImpl(bestLink.getParent(), bestLink.getParent(), bestLink.getType());
                rchildren.add(reflexiveLink);
            }
            for (Link candidateLink : rchildren) {
                Collection<Explanation> existingExpls;
                LinkedObject candidateSubClass;
                Link existingLink;
                prop = candidateLink.getType();
                if (!prop.equals(bestLink.getType()) || (existingLink = reasoner.hasRelationship(candidateSubClass = candidateLink.getChild(), prop, xp)) != null && !this.onlyGiven(existingExpls = reasoner.getExplanations(existingLink))) continue;
                boolean satisfies = true;
                for (Link nsLink : (Collection)this.intersectionMap.get((Object)xp)) {
                    if (nsLink.equals(bestLink) || reasoner.hasRelationship(candidateSubClass, nsLink.getType(), nsLink.getParent()) != null) continue;
                    satisfies = false;
                    break;
                }
                if (!satisfies) continue;
                candidateSubClasses.add(candidateSubClass);
            }
            if (reflexiveLink != null) {
                rchildren.remove(reflexiveLink);
            }
            for (LinkedObject candidate : candidateSubClasses) {
                Link out = this.createLink(candidate, OBOProperty.IS_A, xp);
                CompletenessExplanation exp = new CompletenessExplanation();
                exp.setExplainedLink(out);
                for (Link nsLink : (Collection)this.intersectionMap.get((Object)xp)) {
                    Link matchLink = this.createLink(candidate, nsLink.getType(), nsLink.getParent());
                    CompletenessMatch m = new CompletenessMatch(matchLink, nsLink);
                    exp.addMatch(m);
                }
                expls.add(exp);
            }
        }
        this.ruleTime += System.nanoTime() - time;
        return expls;
    }
}

