/*
 * Decompiled with CFR 0.152.
 */
package org.obo.reasoner.rbr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOProperty;
import org.obo.reasoner.Explanation;
import org.obo.reasoner.ReasonedLinkDatabase;
import org.obo.reasoner.rbr.AbstractRule;
import org.obo.reasoner.rbr.LinkCompositionExplanation;
import org.obo.reasoner.rbr.RelationCompositionTable;
import org.obo.reasoner.rbr.RuleBasedReasoner;

public class LinkCompositionRule
extends AbstractRule {
    protected static final Logger logger = Logger.getLogger(LinkCompositionRule.class);

    @Override
    public Collection<Explanation> getNewInferences(ReasonedLinkDatabase reasoner) {
        RelationCompositionTable rct = ((RuleBasedReasoner)reasoner).getRelationCompositionTable();
        long time = System.nanoTime();
        ArrayList<Explanation> expls = new ArrayList<Explanation>();
        for (IdentifiedObject a : reasoner.getObjects()) {
            if (!(a instanceof LinkedObject)) continue;
            LinkedObject ao = (LinkedObject)a;
            HashSet<Link> seenLinks = new HashSet<Link>();
            HashSet<Link> extLinks = new HashSet<Link>();
            for (Link extLink : reasoner.getParents(ao)) {
                if (!rct.hasComposition(extLink.getType())) continue;
                extLinks.add(extLink);
            }
            while (extLinks.size() > 0) {
                HashSet<Link> newExtLinks = new HashSet<Link>();
                for (Link link1 : extLinks) {
                    LinkedObject bo = link1.getParent();
                    OBOProperty r1 = link1.getType();
                    for (Link link2 : reasoner.getParents(bo)) {
                        LinkedObject co = link2.getParent();
                        OBOProperty r2 = link2.getType();
                        Set<OBOProperty> inferredProps = rct.lookup(r1, r2);
                        for (OBOProperty inferredProp : inferredProps) {
                            Collection<Explanation> existingExpls;
                            Link existingLink;
                            Link out = this.createLink(ao, inferredProp, co);
                            if (seenLinks.contains(out) || (existingLink = reasoner.hasRelationship(ao, inferredProp, co)) != null && !this.onlyGiven(existingExpls = reasoner.getExplanations(existingLink))) continue;
                            LinkCompositionExplanation exp = new LinkCompositionExplanation(this.createLink(ao, r1, bo), this.createLink(bo, r2, co));
                            exp.setExplainedLink(out);
                            expls.add(exp);
                            if (rct.hasComposition(out.getType())) {
                                newExtLinks.add(out);
                            }
                            seenLinks.add(out);
                        }
                    }
                }
                extLinks = newExtLinks;
            }
        }
        this.ruleTime += System.nanoTime() - time;
        return expls;
    }
}

