/*
 * Decompiled with CFR 0.152.
 */
package org.obo.reasoner.rbr;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.bbop.util.MultiHashMap;
import org.bbop.util.MultiMap;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOProperty;
import org.obo.reasoner.Explanation;
import org.obo.reasoner.ReasonedLinkDatabase;
import org.obo.reasoner.rbr.AbstractRule;
import org.obo.reasoner.rbr.PropertyIntersectionExplanation;
import org.obo.util.TermUtil;

public class PropertyIntersectionRule
extends AbstractRule {
    protected static final Logger logger = Logger.getLogger(PropertyIntersectionRule.class);
    protected MultiMap<OBOProperty, OBOProperty> propertyIntersectionMap;
    protected MultiMap<OBOProperty, OBOProperty> hintMap;
    protected MultiMap<OBOProperty, OBOProperty> piMap;

    @Override
    public void init(ReasonedLinkDatabase reasoner) {
        super.init(reasoner);
        this.buildPropertyIntersectionMap(reasoner);
    }

    protected void buildPropertyIntersectionMap(ReasonedLinkDatabase reasoner) {
        this.propertyIntersectionMap = new MultiHashMap();
        this.hintMap = new MultiHashMap();
        this.piMap = new MultiHashMap();
        for (IdentifiedObject io : reasoner.getObjects()) {
            if (!(io instanceof OBOProperty)) continue;
            OBOProperty p = (OBOProperty)io;
            for (Link link : p.getParents()) {
                if (!TermUtil.isIntersection(link)) continue;
                this.propertyIntersectionMap.add((Object)p, (Object)((OBOProperty)link.getParent()));
                this.hintMap.add((Object)((OBOProperty)link.getParent()), (Object)p);
                this.piMap.add((Object)p, (Object)((OBOProperty)link.getParent()));
            }
        }
    }

    @Override
    public Collection<Explanation> getNewInferences(ReasonedLinkDatabase reasoner) {
        ArrayList<Explanation> expls = new ArrayList<Explanation>();
        if (this.piMap == null) {
            return expls;
        }
        for (OBOProperty inferredProp : this.piMap.keySet()) {
            Integer minSize = null;
            OBOProperty bestProp = null;
            for (OBOProperty iProp : (Collection)this.piMap.get((Object)inferredProp)) {
                int numLinks = reasoner.getLinks(iProp).size();
                if (minSize != null && numLinks >= minSize) continue;
                minSize = numLinks;
                bestProp = iProp;
            }
            ArrayList<Link> additionalSupportingLinks = new ArrayList<Link>();
            for (Link candidateSupportingLink : reasoner.getLinks(bestProp)) {
                LinkedObject su = candidateSupportingLink.getChild();
                LinkedObject ob = candidateSupportingLink.getParent();
                boolean isMatch = true;
                for (OBOProperty iProp : (Collection)this.piMap.get((Object)inferredProp)) {
                    if (iProp.equals(bestProp)) continue;
                    if (!reasoner.getParentsOfType(su, iProp).contains(ob)) {
                        isMatch = false;
                        break;
                    }
                    additionalSupportingLinks.add(this.createLink(su, iProp, ob));
                }
                if (!isMatch) continue;
                Link out = this.createLink(su, inferredProp, candidateSupportingLink.getParent());
                PropertyIntersectionExplanation exp = new PropertyIntersectionExplanation();
                exp.setExplainedLink(out);
                exp.addEvidence(candidateSupportingLink);
                for (Link sl : additionalSupportingLinks) {
                    exp.addEvidence(sl);
                }
                expls.add(exp);
            }
        }
        return expls;
    }
}

