/*
 * Decompiled with CFR 0.152.
 */
package org.obo.reasoner.rbr;

import java.util.Collection;
import org.apache.log4j.Logger;
import org.obo.datamodel.Link;
import org.obo.datamodel.OBOSession;
import org.obo.datamodel.impl.OBORestrictionImpl;
import org.obo.history.CompletesHistoryItem;
import org.obo.history.CreateLinkHistoryItem;
import org.obo.history.DeleteLinkHistoryItem;
import org.obo.history.HistoryItem;
import org.obo.history.OperationModel;
import org.obo.history.OperationWarning;
import org.obo.history.StringRelationship;
import org.obo.reasoner.ReasonedLinkDatabase;
import org.obo.util.HistoryUtil;

public class ReasonerOperationModel
implements OperationModel {
    protected static final Logger logger = Logger.getLogger(ReasonerOperationModel.class);
    protected ReasonedLinkDatabase reasoner;
    protected OBOSession session;

    public ReasonerOperationModel(ReasonedLinkDatabase reasoner) {
        this.setReasoner(reasoner);
    }

    public void setReasoner(ReasonedLinkDatabase reasoner) {
        this.reasoner = reasoner;
    }

    @Override
    public void setSession(OBOSession history) {
        this.session = history;
    }

    public ReasonedLinkDatabase getReasoner() {
        return this.reasoner;
    }

    @Override
    public void addLockstepModel(OperationModel model) {
    }

    @Override
    public void removeLockstepModel(OperationModel model) {
    }

    public OperationWarning apply(Collection<HistoryItem> items) {
        Collection links = null;
        for (HistoryItem item : items) {
            if (!(item instanceof CreateLinkHistoryItem)) continue;
            CreateLinkHistoryItem tchi = (CreateLinkHistoryItem)item;
            StringRelationship sr = new StringRelationship(tchi.getTarget(), tchi.getTypeID(), tchi.getParentID());
            Link tr = HistoryUtil.createRealRel(this.session, sr);
            links.add(tr);
        }
        this.reasoner.addLinks(links);
        return null;
    }

    @Override
    public OperationWarning apply(HistoryItem item) {
        if (item instanceof CreateLinkHistoryItem) {
            CreateLinkHistoryItem tchi = (CreateLinkHistoryItem)item;
            StringRelationship sr = new StringRelationship(tchi.getTarget(), tchi.getTypeID(), tchi.getParentID());
            Link tr = HistoryUtil.createRealRel(this.session, sr);
            this.reasoner.addLink(tr);
        } else if (item instanceof DeleteLinkHistoryItem) {
            DeleteLinkHistoryItem dlhi = (DeleteLinkHistoryItem)item;
            StringRelationship sr = dlhi.getRel();
            Link link = HistoryUtil.createRealRel(this.session, sr);
            this.reasoner.removeLink(link);
        } else if (item instanceof CompletesHistoryItem) {
            CompletesHistoryItem chi = (CompletesHistoryItem)item;
            Link link = HistoryUtil.getRealRel(this.session, chi.getRel());
            this.setCompleteness(link, !chi.getOldCompletes());
        }
        return null;
    }

    @Override
    public OperationWarning reverse(HistoryItem item) {
        if (item instanceof CreateLinkHistoryItem) {
            CreateLinkHistoryItem tchi = (CreateLinkHistoryItem)item;
            StringRelationship sr = new StringRelationship(tchi.getTarget(), tchi.getTypeID(), tchi.getParentID());
            Link link = HistoryUtil.createRealRel(this.session, sr);
            this.reasoner.removeLink(link);
        } else if (item instanceof DeleteLinkHistoryItem) {
            DeleteLinkHistoryItem dlhi = (DeleteLinkHistoryItem)item;
            StringRelationship sr = dlhi.getRel();
            Link link = HistoryUtil.createRealRel(this.session, sr);
            this.reasoner.addLink(link);
        } else if (item instanceof CompletesHistoryItem) {
            CompletesHistoryItem chi = (CompletesHistoryItem)item;
            Link link = HistoryUtil.getRealRel(this.session, chi.getRel());
            this.setCompleteness(link, chi.getOldCompletes());
        }
        return null;
    }

    protected void setCompleteness(Link link, boolean completes) {
        this.reasoner.removeLink(new OBORestrictionImpl(link, !completes));
        this.reasoner.addLink(new OBORestrictionImpl(link, completes));
    }
}

