/*
 * Decompiled with CFR 0.152.
 */
package org.obo.reasoner.rbr;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.obo.datamodel.LinkDatabase;
import org.obo.datamodel.OBOProperty;
import org.obo.util.TermUtil;

public class RelationCompositionTable {
    protected static final Logger logger = Logger.getLogger(RelationCompositionTable.class);
    private Map<OBOProperty, Map<OBOProperty, Set<OBOProperty>>> propertyMap;
    private final HashSet<OBOProperty> emptySet = new HashSet();
    private Collection<OBOProperty> properties;

    public RelationCompositionTable(LinkDatabase ldb) {
        this.initialize(ldb);
    }

    public void initialize(LinkDatabase ldb) {
        this.propertyMap = new HashMap<OBOProperty, Map<OBOProperty, Set<OBOProperty>>>();
        OBOProperty is_a = OBOProperty.IS_A;
        this.properties = new HashSet<OBOProperty>();
        this.properties.addAll(ldb.getProperties());
        this.properties.add(is_a);
        for (OBOProperty a : this.properties) {
            if (a.isNonInheritable() || a.getDisjointOver() != null) continue;
            if (a.isTransitive()) {
                this.add(a, a, a);
            }
            if (!a.equals(is_a)) {
                this.add(a, is_a, a);
                this.add(is_a, a, a);
            }
            if (a.getTransitiveOver() != null) {
                this.add(a, a.getTransitiveOver(), a);
            }
            if (a.getHoldsOverChains() == null) continue;
            for (List<OBOProperty> chain : a.getHoldsOverChains()) {
                if (chain.size() != 2) {
                    logger.error((Object)("only chains of size 2 allowed. Illegal: " + chain));
                    continue;
                }
                this.add(chain.get(0), chain.get(1), a);
            }
        }
    }

    public boolean hasComposition(OBOProperty a) {
        return this.propertyMap.containsKey(a);
    }

    public Set<OBOProperty> lookup(OBOProperty a, OBOProperty b) {
        if (this.propertyMap.containsKey(a) && this.propertyMap.get(a).containsKey(b)) {
            return this.propertyMap.get(a).get(b);
        }
        return this.emptySet;
    }

    public void add(OBOProperty a, OBOProperty b, OBOProperty c) {
        Collection<OBOProperty> acs = TermUtil.getSubProperties(a);
        Collection<OBOProperty> bcs = TermUtil.getSubProperties(b);
        acs.add(a);
        bcs.add(b);
        for (OBOProperty ac : acs) {
            for (OBOProperty bc : bcs) {
                this.directAdd(ac, bc, c);
            }
        }
    }

    public void directAdd(OBOProperty a, OBOProperty b, OBOProperty c) {
        if (!this.propertyMap.containsKey(a)) {
            this.propertyMap.put(a, new HashMap());
        }
        if (!this.propertyMap.get(a).containsKey(b)) {
            this.propertyMap.get(a).put(b, new HashSet());
        }
        this.propertyMap.get(a).get(b).add(c);
    }

    private String relationLabel(Collection<OBOProperty> ps) {
        StringBuffer sb = new StringBuffer("[");
        for (OBOProperty p : ps) {
            sb.append(" " + this.relationLabel(p));
        }
        return sb.toString() + " ]";
    }

    private String relationLabel(OBOProperty p) {
        if (p.getName() != null) {
            return p.getName();
        }
        return p.getID();
    }

    public String toTable() {
        StringBuffer sb = new StringBuffer();
        for (OBOProperty b : this.properties) {
            sb.append("\t" + this.relationLabel(b));
        }
        sb.append("\n");
        for (OBOProperty a : this.properties) {
            sb.append(this.relationLabel(a));
            for (OBOProperty b : this.properties) {
                sb.append("\t" + this.relationLabel(this.lookup(a, b)));
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

