/*
 * Decompiled with CFR 0.152.
 */
package org.obo.reasoner.rbr;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOProperty;
import org.obo.reasoner.Explanation;
import org.obo.reasoner.ReasonedLinkDatabase;
import org.obo.reasoner.rbr.AbstractRule;
import org.obo.reasoner.rbr.LinkCompositionExplanation;

public class SubPropertyRule
extends AbstractRule {
    protected static final Logger logger = Logger.getLogger(SubPropertyRule.class);

    @Override
    public Collection<Explanation> getNewInferences(ReasonedLinkDatabase reasoner) {
        ArrayList<Explanation> expls = new ArrayList<Explanation>();
        if (reasoner.getProperties() == null) {
            logger.error((Object)"no properties to make new inferences. Reasoner not initialized?");
            return null;
        }
        for (OBOProperty subProp : reasoner.getProperties()) {
            Collection<LinkedObject> superProps = reasoner.getParentsOfType(subProp, OBOProperty.IS_A);
            if (superProps.size() <= 0) continue;
            Collection<Link> links = reasoner.getLinks(subProp);
            for (Link link : links) {
                for (LinkedObject superProp : superProps) {
                    Link out = this.createLink(link.getChild(), (OBOProperty)superProp, link.getParent());
                    LinkCompositionExplanation exp = new LinkCompositionExplanation(link, null);
                    exp.setExplainedLink(out);
                    expls.add(exp);
                }
            }
        }
        return expls;
    }
}

