/*
 * Decompiled with CFR 0.152.
 */
package org.obo.reasoner.rbr;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.obo.datamodel.Link;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.impl.OBORestrictionImpl;
import org.obo.reasoner.Explanation;
import org.obo.reasoner.ReasonedLinkDatabase;
import org.obo.reasoner.rbr.AbstractRule;

public class TransitiveRelationRule
extends AbstractRule {
    protected static final Logger logger = Logger.getLogger(TransitiveRelationRule.class);
    protected static Link temp = new OBORestrictionImpl();
    long implicationTime;
    long fetchTime;
    long expConstructTime;

    @Override
    public void init(ReasonedLinkDatabase reasoner) {
        super.init(reasoner);
        this.implicationTime = 0L;
        this.fetchTime = 0L;
        this.expConstructTime = 0L;
    }

    @Override
    public Collection<Explanation> getNewInferences(ReasonedLinkDatabase reasoner) {
        ArrayList<Explanation> expls = new ArrayList<Explanation>();
        for (OBOProperty inferredProp : reasoner.getProperties()) {
            if (!inferredProp.isTransitive()) continue;
            expls.addAll(this.getNewInferencesForComposition(reasoner, inferredProp, inferredProp, inferredProp));
        }
        OBOProperty is_a = OBOProperty.IS_A;
        expls.addAll(this.getNewInferencesForComposition(reasoner, is_a, is_a, is_a));
        return expls;
    }

    public String toString() {
        return "Transitivity rule (implicationTime = " + (double)this.implicationTime / 1000000.0 + ", expConstTime = " + (double)this.expConstructTime / 1000000.0 + ", fetchTime = " + (double)this.fetchTime / 1000000.0 + ")";
    }
}

