/*
 * Decompiled with CFR 0.152.
 */
package org.obo.reasoner.rbr;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOProperty;
import org.obo.reasoner.Explanation;
import org.obo.reasoner.ReasonedLinkDatabase;
import org.obo.reasoner.rbr.AbstractRule;
import org.obo.reasoner.rbr.LinkCompositionExplanation;
import org.obo.util.TermUtil;

public class UnionOfRule
extends AbstractRule {
    protected static final Logger logger = Logger.getLogger(UnionOfRule.class);
    private ArrayList<Explanation> expls;

    @Override
    public void init(ReasonedLinkDatabase reasoner) {
        super.init(reasoner);
        this.expls = new ArrayList();
        for (IdentifiedObject io : reasoner.getObjects()) {
            if (!(io instanceof LinkedObject)) continue;
            LinkedObject lo = (LinkedObject)io;
            for (Link link : lo.getParents()) {
                if (!TermUtil.isUnion(link)) continue;
                Link out = this.createLink(link.getParent(), OBOProperty.IS_A, link.getChild());
                LinkCompositionExplanation exp = new LinkCompositionExplanation(link, null);
                exp.setExplainedLink(out);
                this.expls.add(exp);
            }
        }
    }

    @Override
    public Collection<Explanation> getNewInferences(ReasonedLinkDatabase reasoner) {
        ArrayList<Explanation> newExpls = this.expls;
        if (this.expls.size() > 0) {
            this.expls = new ArrayList();
        }
        return newExpls;
    }
}

