/*
 * Decompiled with CFR 0.152.
 */
package org.obo.test;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Properties;
import junit.framework.TestCase;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.bbop.dataadapter.AdapterConfiguration;
import org.bbop.dataadapter.DataAdapterException;
import org.obo.dataadapter.OBOAdapter;
import org.obo.dataadapter.OBOFileAdapter;
import org.obo.datamodel.CommentedObject;
import org.obo.datamodel.Dbxref;
import org.obo.datamodel.DbxrefedObject;
import org.obo.datamodel.DefinedObject;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Instance;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkDatabase;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.Namespace;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.OBOSession;
import org.obo.datamodel.SubsetObject;
import org.obo.datamodel.Synonym;
import org.obo.datamodel.SynonymedObject;
import org.obo.datamodel.TermSubset;
import org.obo.datamodel.impl.DefaultLinkDatabase;
import org.obo.datamodel.impl.OBORestrictionImpl;
import org.obo.filters.Filter;
import org.obo.reasoner.impl.ForwardChainingReasoner;
import org.obo.util.TermUtil;

public abstract class AbstractOBOTest
extends TestCase {
    protected OBOSession session;
    protected LinkDatabase linkDatabase;
    protected static final Logger logger = Logger.getLogger(AbstractOBOTest.class);

    public AbstractOBOTest(String name) {
        super(name);
    }

    public abstract Collection<String> getFilesToLoad();

    public boolean getAllowDangling() {
        return false;
    }

    public void setUp() throws Exception {
        Properties props = new Properties();
        props.setProperty("log4j.rootLogger", "DEBUG, A1");
        props.setProperty("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        props.setProperty("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
        props.setProperty("log4j.appender.A1.layout.ConversionPattern", "%d [%t] %-5p %c - %m%n");
        PropertyConfigurator.configure((Properties)props);
        logger.info((Object)("Setting up: " + (Object)((Object)this)));
        ForwardChainingReasoner.checkRecache = false;
        this.session = this.getSessionFromResources(this.getFilesToLoad());
        this.linkDatabase = new DefaultLinkDatabase(this.session);
    }

    protected OBOSession getSessionFromResources(Collection<String> names) throws DataAdapterException {
        OBOFileAdapter adapter = new OBOFileAdapter();
        OBOFileAdapter.OBOAdapterConfiguration config = new OBOFileAdapter.OBOAdapterConfiguration();
        for (String f : names) {
            String path = f.startsWith("/") || f.startsWith("http:") ? f : this.getResourcePath() + "/" + f;
            config.getReadPaths().add(path);
        }
        config.setAllowDangling(true);
        config.setBasicSave(false);
        config.setFailFast(false);
        this.session = adapter.doOperation(OBOAdapter.READ_ONTOLOGY, (AdapterConfiguration)config, null);
        return this.session;
    }

    public void readOBOFile(File file) throws DataAdapterException {
        OBOFileAdapter adapter = new OBOFileAdapter();
        OBOFileAdapter.OBOAdapterConfiguration config = new OBOFileAdapter.OBOAdapterConfiguration();
        config.getReadPaths().add(file.getAbsolutePath());
        config.setAllowDangling(true);
        this.session = adapter.doOperation(OBOAdapter.READ_ONTOLOGY, (AdapterConfiguration)config, null);
    }

    protected String getResourcePath() {
        return "test_resources";
    }

    public void tearDown() throws Exception {
        this.session = null;
    }

    public void testForIsA(String childID, String parentID) {
        LinkedObject child = (LinkedObject)this.session.getObject(childID);
        LinkedObject parent = (LinkedObject)this.session.getObject(parentID);
        AbstractOBOTest.assertTrue((boolean)child.getParents().contains(new OBORestrictionImpl(child, OBOProperty.IS_A, parent)));
    }

    public void testForTransitiveOver(String childID, String parentID) {
        OBOProperty child = (OBOProperty)this.session.getObject(childID);
        OBOProperty parent = (OBOProperty)this.session.getObject(parentID);
        AbstractOBOTest.assertTrue((boolean)child.getTransitiveOver().equals(parent));
    }

    public void testForNonGenusIsA(String childID, String parentID) {
        LinkedObject child = (LinkedObject)this.session.getObject(childID);
        LinkedObject parent = (LinkedObject)this.session.getObject(parentID);
        OBORestrictionImpl link = new OBORestrictionImpl(child, OBOProperty.IS_A, parent);
        link.setCompletes(false);
        AbstractOBOTest.assertTrue((boolean)child.getParents().contains(link));
    }

    public void testForNoIsA(String childID, String parentID) {
        LinkedObject child = (LinkedObject)this.session.getObject(childID);
        LinkedObject parent = (LinkedObject)this.session.getObject(parentID);
        AbstractOBOTest.assertFalse((boolean)child.getParents().contains(new OBORestrictionImpl(child, OBOProperty.IS_A, parent)));
    }

    public void testForGenus(String childID, String parentID) {
        LinkedObject child = (LinkedObject)this.session.getObject(childID);
        LinkedObject parent = (LinkedObject)this.session.getObject(parentID);
        boolean ok = false;
        for (Link link : child.getParents()) {
            if (!TermUtil.isIntersection(link) || !link.getType().equals(OBOProperty.IS_A) || !link.getParent().equals(parent)) continue;
            ok = true;
        }
        AbstractOBOTest.assertTrue((boolean)ok);
    }

    public void testForDifferentium(String childID, String relID, String parentID) {
        LinkedObject child = (LinkedObject)this.session.getObject(childID);
        LinkedObject parent = (LinkedObject)this.session.getObject(parentID);
        boolean ok = false;
        for (Link link : child.getParents()) {
            if (!TermUtil.isIntersection(link) || !link.getType().getID().equals(relID) || !link.getParent().equals(parent)) continue;
            ok = true;
        }
        AbstractOBOTest.assertTrue((boolean)ok);
    }

    public void testForIsTransitive(String propID) {
        OBOProperty prop = (OBOProperty)this.session.getObject(propID);
        AbstractOBOTest.assertTrue((boolean)prop.isTransitive());
    }

    public void testForLink(String childID, String relID, String parentID) {
        LinkedObject child = (LinkedObject)this.session.getObject(childID);
        LinkedObject parent = (LinkedObject)this.session.getObject(parentID);
        OBOProperty rel = (OBOProperty)this.session.getObject(relID);
        AbstractOBOTest.assertTrue((boolean)child.getParents().contains(new OBORestrictionImpl(child, rel, parent)));
    }

    public void testForCategory(String childID, String catName) {
        SubsetObject child = (SubsetObject)((Object)this.session.getObject(childID));
        TermSubset cat = this.session.getCategory(catName);
        AbstractOBOTest.assertTrue((boolean)child.getSubsets().contains(cat));
    }

    public void testForDbxref(String childID, String xrefStr) {
        DbxrefedObject child = (DbxrefedObject)((Object)this.session.getObject(childID));
        boolean ok = false;
        for (Dbxref x : child.getDbxrefs()) {
            if (!xrefStr.equals(x.toString())) continue;
            ok = true;
        }
        AbstractOBOTest.assertTrue((boolean)ok);
    }

    public void testForSynonym(String id, String syn) {
        SynonymedObject io = (SynonymedObject)this.session.getObject(id);
        boolean ok = false;
        for (Synonym x : io.getSynonyms()) {
            if (!x.getText().equals(syn)) continue;
            ok = true;
        }
        AbstractOBOTest.assertTrue((boolean)ok);
    }

    public void testForNamespace(String id, String nsId) {
        LinkedObject lo = (LinkedObject)this.session.getObject(id);
        Namespace ns = lo.getNamespace();
        AbstractOBOTest.assertTrue((boolean)ns.getID().equals(nsId));
    }

    public void testForDefinition(String id, String def) {
        DefinedObject lo = (DefinedObject)this.session.getObject(id);
        String defCurr = lo.getDefinition();
        AbstractOBOTest.assertTrue((boolean)defCurr.equals(def));
    }

    public void testForComment(String id, String comment) {
        CommentedObject lo = (CommentedObject)this.session.getObject(id);
        String commentCurr = lo.getComment();
        AbstractOBOTest.assertTrue((boolean)commentCurr.equals(comment));
    }

    public void testForName(String id, String name) {
        IdentifiedObject lo = this.session.getObject(id);
        AbstractOBOTest.assertTrue((boolean)lo.getName().equals(name));
    }

    public void testInstanceType(String id, String type) {
        Instance lo = (Instance)this.session.getObject(id);
        AbstractOBOTest.assertTrue((boolean)lo.getType().getID().equals(type));
    }

    public void testNotPresent(String id) {
        AbstractOBOTest.assertTrue((this.session.getObject(id) == null ? 1 : 0) != 0);
    }

    public File writeTempOBOFile() throws IOException, DataAdapterException {
        OBOFileAdapter adapter = new OBOFileAdapter();
        OBOFileAdapter.OBOAdapterConfiguration config = new OBOFileAdapter.OBOAdapterConfiguration();
        File outFile = File.createTempFile("foo", "bar");
        config.setWritePath(outFile.getAbsolutePath());
        adapter.doOperation(OBOAdapter.WRITE_ONTOLOGY, (AdapterConfiguration)config, this.session);
        return outFile;
    }

    public Collection<Link> filterLinks(Filter filter) {
        LinkedList<Link> matches = new LinkedList<Link>();
        for (IdentifiedObject io : this.session.getObjects()) {
            if (!(io instanceof LinkedObject)) continue;
            LinkedObject lo = (LinkedObject)io;
            for (Link link : lo.getParents()) {
                if (!filter.satisfies(link)) continue;
                matches.add(link);
            }
        }
        return matches;
    }
}

